/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.extensions;

import com.sap.jvm.impl.extensions.WithExtensionsNativeLib;
import com.sap.jvm.monitor.MonitoringPermission;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashSet;

public final class CapabilitiesImpl
extends WithExtensionsNativeLib {
    private static final boolean hasExtendedStackTrace;
    private static final boolean hasDebuggingOnDemand;
    private static final boolean hasRestrictedDebugging;
    private static final boolean hasVmMonitoring;
    private static final boolean hasSharedSessionStore;
    private static final boolean hasIoStatistics;
    private static final boolean hasVMOptionAPI;
    private static final boolean hasProfilingAPI;

    public static boolean hasExtendedStackTrace() {
        return hasExtendedStackTrace;
    }

    public static boolean hasDebuggingOnDemand() {
        return hasDebuggingOnDemand;
    }

    public static boolean hasRestrictedDebugging() {
        return hasRestrictedDebugging;
    }

    public static boolean hasVmMonitoring() {
        return hasVmMonitoring;
    }

    public static boolean hasSharedSessionStore() {
        return hasSharedSessionStore;
    }

    public static boolean hasIoStatistics() {
        return hasIoStatistics;
    }

    public static boolean hasVMOptionAPI() {
        return hasVMOptionAPI;
    }

    public static boolean hasProfilingAPI() {
        return hasProfilingAPI;
    }

    private static native byte[] getCapabilities0();

    static {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        HashSet<String> nativeCapabilities = new HashSet<String>();
        try {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(CapabilitiesImpl.getCapabilities0()));
            while (dis.available() > 0) {
                nativeCapabilities.add(dis.readUTF());
            }
        }
        catch (IOException e) {
            throw new InternalError("Unexpected exception while reading capabilities.", e);
        }
        hasExtendedStackTrace = nativeCapabilities.contains("extendedStackTrace");
        hasDebuggingOnDemand = nativeCapabilities.contains("debuggingOnDemand");
        hasRestrictedDebugging = nativeCapabilities.contains("restrictedDebugging");
        hasVmMonitoring = nativeCapabilities.contains("vmMonitoring");
        hasSharedSessionStore = nativeCapabilities.contains("sharedSessionStore");
        hasIoStatistics = nativeCapabilities.contains("iostat");
        hasVMOptionAPI = nativeCapabilities.contains("VMOptionAPI");
        hasProfilingAPI = nativeCapabilities.contains("profilingAPI");
    }
}

