/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.extensions;

import com.sap.jvm.VMOption;
import com.sap.jvm.VMOptionUsage;
import com.sap.jvm.impl.extensions.WithExtensionsNativeLib;
import com.sap.jvm.monitor.MonitoringPermission;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public final class VMOptionImpl
extends VMOption {
    public VMOptionImpl(DataInputStream stream) throws IOException {
        this.format = stream.readUTF();
        this.syntax = stream.readUTF();
        this.description = stream.readUTF();
        int usageIndex = stream.readInt();
        VMOptionUsage[] optionUsages = VMOptionUsage.values();
        if (optionUsages.length <= usageIndex) {
            throw new IOException("Invalid option usage with index " + usageIndex);
        }
        this.usage = optionUsages[usageIndex];
    }

    public static VMOption[] readVMOptions() {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        try {
            DataInputStream stream = new DataInputStream(new ByteArrayInputStream(VMOptionImpl.getVMOptions0()));
            int nrOfOptions = stream.readInt();
            VMOption[] result = new VMOption[nrOfOptions];
            for (int i = 0; i < nrOfOptions; ++i) {
                result[i] = new VMOptionImpl(stream);
            }
            return result;
        }
        catch (IOException e) {
            throw new InternalError("Unexpected exception while reading options.", e);
        }
    }

    private static native byte[] getVMOptions0();

    static {
        WithExtensionsNativeLib.load();
    }
}

