/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.extensions.cluster;

import com.sap.jvm.impl.extensions.WithExtensionsNativeLib;
import com.sap.jvm.impl.extensions.vm.ClusteredVmImpl;
import com.sap.jvm.impl.extensions.vm.CurrentVmImpl;
import com.sap.jvm.impl.monitor.cluster.ClusterInfoImpl;
import com.sap.jvm.impl.monitor.cluster.ClusteredVm;
import com.sap.jvm.impl.monitor.cluster.InstanceClusterInfoImpl;
import com.sap.jvm.impl.monitor.cluster.ProcessClusterInfoImpl;
import com.sap.jvm.monitor.MonitoringPermission;
import com.sap.jvm.monitor.cluster.ClusterInfo;
import com.sap.jvm.monitor.cluster.ClusterType;
import com.sap.jvm.monitor.cluster.InstanceClusterInfo;
import com.sap.jvm.monitor.cluster.ProcessClusterInfo;
import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.tracing.Trace;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import jdk.internal.misc.JavaLangProcessAccess;
import jdk.internal.misc.SharedSecrets;

public final class ClusterImpl
extends WithExtensionsNativeLib {
    private static JavaLangProcessAccess jlpa = SharedSecrets.getJavaLangProcessAccess();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ClusterInfo[] getClusterInfo() {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        byte[] data = ClusterImpl.getClusterInfo0();
        if (data == null) {
            return new ClusterInfo[0];
        }
        try (DataInputStream stream = new DataInputStream(new ByteArrayInputStream(data));){
            int numberElements = stream.readInt();
            ClusterInfo[] retValue = new ClusterInfo[numberElements];
            for (int i = 0; i < numberElements; ++i) {
                boolean attachable = stream.readBoolean();
                int typeId = stream.readInt();
                int id = stream.readInt();
                ClusterType type = ClusterType.getTypeForIndex(typeId);
                retValue[i] = type == ClusterType.CLUSTER_TYPE_PROCESS ? new ProcessClusterInfoImpl(id, attachable) : (type == ClusterType.CLUSTER_TYPE_INSTANCE ? new InstanceClusterInfoImpl(id, attachable) : new ClusterInfoImpl(type, attachable));
            }
            ClusterInfo[] clusterInfoArray = retValue;
            return clusterInfoArray;
        }
        catch (IOException | IllegalArgumentException e) {
            Trace.get(ClusterImpl.class).error((Throwable)e, "Exception reading cluster monitoring information.");
            return new ClusterInfo[0];
        }
    }

    public static ClusteredVm getVm(int processId) {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        CurrentVmImpl currentVm = CurrentVmImpl.get();
        if (currentVm.getPid() == (long)processId) {
            return currentVm;
        }
        ClusterInfo[] clusterInfo = ClusterImpl.getClusterInfo();
        for (int i = 0; i < clusterInfo.length; ++i) {
            if (!clusterInfo[i].isAttachable()) continue;
            if (clusterInfo[i].getType() == ClusterType.CLUSTER_TYPE_PROCESS && ((ProcessClusterInfo)clusterInfo[i]).getProcessId() == processId) {
                return new ClusteredVmImpl(ClusterType.CLUSTER_TYPE_PROCESS, processId, 0);
            }
            if (clusterInfo[i].getType() != ClusterType.CLUSTER_TYPE_INSTANCE) continue;
            InstanceClusterInfo instanceInfo = (InstanceClusterInfo)clusterInfo[i];
            ClusteredVm[] vms = ClusterImpl.getInstanceVms(instanceInfo.getInstanceId());
            for (int k = 0; k < vms.length; ++k) {
                try {
                    if (vms[k].getStateInfo().getPid() != processId) continue;
                    return vms[k];
                }
                catch (InvalidVmException invalidVmException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static ClusteredVm[] getInstanceVms(int instanceId) {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        int maxVms = ClusterImpl.getMaxVms0(ClusterType.getConfigurationIndex(ClusterType.CLUSTER_TYPE_INSTANCE), instanceId);
        if (maxVms == -1) {
            return new ClusteredVm[0];
        }
        int validVms = 0;
        ClusteredVm[] rawVms = new ClusteredVm[maxVms];
        for (int i = 0; i < maxVms; ++i) {
            rawVms[validVms] = new ClusteredVmImpl(ClusterType.CLUSTER_TYPE_INSTANCE, instanceId, i);
            ++validVms;
        }
        ClusteredVm[] result = new ClusteredVm[validVms];
        System.arraycopy(rawVms, 0, result, 0, validVms);
        return result;
    }

    public static long getPid(Process process) {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        return jlpa.getPid(process);
    }

    public static void cleanSharedResources(int instanceId) {
        MonitoringPermission.checkPermission(MonitoringPermission.EXECUTE_PERMISSION);
        ClusterImpl.cleanIpc0(ClusterType.getConfigurationIndex(ClusterType.CLUSTER_TYPE_INSTANCE), instanceId);
    }

    private static native byte[] getClusterInfo0();

    private static native int getMaxVms0(int var0, int var1);

    private static native void cleanIpc0(int var0, int var1);
}

