/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.extensions.vm;

import com.sap.jvm.impl.extensions.WithExtensionsNativeLib;
import com.sap.jvm.impl.monitor.cluster.ClusteredVm;
import com.sap.jvm.impl.monitor.vm.VmDebugInfoImpl;
import com.sap.jvm.impl.monitor.vm.VmMemoryInfoImpl;
import com.sap.jvm.impl.monitor.vm.VmProfilingInfoImpl;
import com.sap.jvm.impl.monitor.vm.VmSnapshotImpl;
import com.sap.jvm.impl.monitor.vm.VmStartInfoImpl;
import com.sap.jvm.impl.monitor.vm.VmStateInfoImpl;
import com.sap.jvm.impl.monitor.vm.VmTimeInfoImpl;
import com.sap.jvm.monitor.MonitoringPermission;
import com.sap.jvm.monitor.cluster.ClusterType;
import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.monitor.vm.MonitorOperation;
import com.sap.jvm.monitor.vm.PortRange;
import com.sap.jvm.monitor.vm.VmDebugInfo;
import com.sap.jvm.monitor.vm.VmMemoryInfo;
import com.sap.jvm.monitor.vm.VmProfilingInfo;
import com.sap.jvm.monitor.vm.VmSnapshot;
import com.sap.jvm.monitor.vm.VmStartInfo;
import com.sap.jvm.monitor.vm.VmStateInfo;
import com.sap.jvm.monitor.vm.VmTimeInfo;
import com.sap.jvm.monitor.vm.VmTraceFlag;
import com.sap.jvm.monitor.vm.VmTraceFlagsSet;
import com.sap.jvm.tracing.Trace;
import com.sun.tools.attach.AttachNotSupportedException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class ClusteredVmBase
extends WithExtensionsNativeLib
implements ClusteredVm {
    protected static final String DUMP = "dump";
    private static final String DUMP_CLUSTER_ERR = "Target VM does not support dump operation and cluster fallback failed";
    protected final ClusterType clusterType;
    protected final int clusterOrProcessId;
    protected final int vmIndex;
    protected final long pid;
    protected final int vmUniqueId;
    protected final String encodedVm;

    protected ClusteredVmBase(ClusterType clusterType, int clusterOrProcessId, int vmIndex, int vmUniqueId, long pid) {
        this.clusterType = clusterType;
        this.clusterOrProcessId = clusterOrProcessId;
        this.vmIndex = vmIndex;
        this.vmUniqueId = vmUniqueId;
        this.encodedVm = ClusteredVmBase.encodeVm(vmIndex, vmUniqueId);
        this.pid = pid;
    }

    @Override
    public ClusterType getClusterType() {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        return this.clusterType;
    }

    @Override
    public int getClusterTypeId() {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        return ClusterType.getConfigurationIndex(this.clusterType);
    }

    @Override
    public int getClusterOrProcessId() {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        return this.clusterOrProcessId;
    }

    @Override
    public long getPid() {
        return this.pid;
    }

    @Override
    public int getVmIndex() {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        return this.vmIndex;
    }

    @Override
    public int getVmUniqueId() {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        return this.vmUniqueId;
    }

    @Override
    public String encode() {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        return this.encodedVm;
    }

    public String toString() {
        return "[VM index=" + this.vmIndex + ", encoded=" + this.encodedVm + "]";
    }

    @Override
    public VmSnapshot getVmSnapshot() throws InvalidVmException {
        try {
            return new VmSnapshotImpl(new DataInputStream(new ByteArrayInputStream(this.getVmSnapshotRaw())));
        }
        catch (IOException e) {
            Trace.get(ClusteredVmBase.class).error((Throwable)e, "Unexpected error reading the VM snapshot information.");
            return null;
        }
    }

    @Override
    public VmMemoryInfo getMemoryInfo() throws InvalidVmException {
        try {
            return new VmMemoryInfoImpl(new DataInputStream(new ByteArrayInputStream(this.getMemoryInfoRaw())));
        }
        catch (IOException e) {
            Trace.get(ClusteredVmBase.class).error((Throwable)e, "Unexpected exception during reading memory information.");
            return null;
        }
    }

    @Override
    public VmTimeInfo getTimeInfo() throws InvalidVmException {
        try {
            return new VmTimeInfoImpl(new DataInputStream(new ByteArrayInputStream(this.getTimeInfoRaw())));
        }
        catch (IOException e) {
            Trace.get(ClusteredVmBase.class).error((Throwable)e, "Unexpected exception during reading time information.");
            return null;
        }
    }

    @Override
    public VmStateInfo getStateInfo() throws InvalidVmException {
        try {
            return new VmStateInfoImpl(new DataInputStream(new ByteArrayInputStream(this.getStateInfoRaw())));
        }
        catch (IOException e) {
            Trace.get(ClusteredVmBase.class).error((Throwable)e, "Unexpected exception during reading state information.");
            return null;
        }
    }

    @Override
    public VmStartInfo getStartInfo() throws InvalidVmException {
        try {
            return new VmStartInfoImpl(new DataInputStream(new ByteArrayInputStream(this.getStartInfoRaw())));
        }
        catch (IOException e) {
            Trace.get(ClusteredVmBase.class).error((Throwable)e, "Unexpected exception during reading start information.");
            return null;
        }
    }

    @Override
    public VmDebugInfo getDebugInfo() throws InvalidVmException {
        try {
            return new VmDebugInfoImpl(new DataInputStream(new ByteArrayInputStream(this.getDebugInfoRaw())));
        }
        catch (IOException e) {
            Trace.get(ClusteredVmBase.class).error((Throwable)e, "Unexpected exception during reading debug information.");
            return null;
        }
    }

    @Override
    public VmProfilingInfo getProfilingInfo() throws InvalidVmException {
        try {
            return new VmProfilingInfoImpl(new DataInputStream(new ByteArrayInputStream(this.getProfilingInfoRaw())));
        }
        catch (IOException e) {
            Trace.get(ClusteredVmBase.class).error((Throwable)e, "Unexpected exception during reading profiling information.");
            return null;
        }
    }

    @Override
    public VmTraceFlagsSet getTraceFlags() throws InvalidVmException {
        int[] flags = this.getTraceFlagsRaw();
        if (flags == null) {
            throw new InvalidVmException(this);
        }
        return ClusteredVmBase.convertIndexArrayToTraceFlagsSet(flags);
    }

    @Override
    public void setTraceFlags(VmTraceFlagsSet traceFlags) throws InvalidVmException {
        int[] flagsIndices = ClusteredVmBase.convertTraceFlagsSetToIndexArray(traceFlags);
        this.setTraceFlagsRaw(flagsIndices, flagsIndices.length);
    }

    @Override
    public void setDefaultProfilingPortRange(PortRange range) throws InvalidVmException {
    }

    @Override
    public void printStackDump() throws IOException {
        this.printStackDump(null);
    }

    @Override
    public void printStackDump(String info) throws IOException {
        MonitoringPermission.checkPermission(MonitoringPermission.EXECUTE_PERMISSION);
        IOException error = null;
        boolean supportsDump = this.supportsDumpOperations();
        if (supportsDump) {
            try {
                this.performOperationVoid(MonitorOperation.GET_STACK_TRACE, "-l", info, DUMP);
            }
            catch (IOException e) {
                error = e;
            }
        }
        if (!(supportsDump && error == null || this.printStackDumpFallback(info))) {
            throw error == null ? new IOException(DUMP_CLUSTER_ERR) : error;
        }
    }

    @Override
    public ArrayList<String> getStackDump() throws IOException {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        return (ArrayList)this.performOperation(MonitorOperation.GET_STACK_TRACE, "-l");
    }

    @Override
    public void dumpHeap() throws IOException {
        this.dumpHeap(null);
    }

    @Override
    public void dumpHeap(String info) throws IOException {
        MonitoringPermission.checkPermission(MonitoringPermission.EXECUTE_PERMISSION);
        IOException error = null;
        boolean supportsDump = this.supportsDumpOperations();
        if (supportsDump) {
            try {
                this.performOperationVoid(MonitorOperation.DUMP_HEAP, null, "-live", info);
            }
            catch (IOException e) {
                error = e;
            }
        }
        if (!(supportsDump && error == null || this.dumpHeapFallback(info))) {
            throw error == null ? new IOException(DUMP_CLUSTER_ERR) : error;
        }
    }

    @Override
    public void dumpGcHistory() throws IOException {
        MonitoringPermission.checkPermission(MonitoringPermission.EXECUTE_PERMISSION);
        IOException error = null;
        boolean supportsDump = this.supportsDumpOperations();
        if (supportsDump) {
            try {
                this.performOperationVoid(MonitorOperation.GET_GC_HISTORY, DUMP);
            }
            catch (IOException e) {
                error = e;
            }
        }
        if (!(supportsDump && error == null || this.dumpGcHistoryFallback())) {
            throw error == null ? new IOException(DUMP_CLUSTER_ERR) : error;
        }
    }

    @Override
    public List<String> getGcHistory() throws IOException {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        return this.performOperation(MonitorOperation.GET_GC_HISTORY, new String[0]);
    }

    @Override
    public byte[] retrieveCompleteGcHistory() throws InvalidVmException {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        try {
            return this.executeAttachOperationReturnArray(MonitorOperation.RETRIEVE_COMPLETE_GC_HISTORY, new String[0]);
        }
        catch (AttachNotSupportedException | IOException e) {
            Trace.get(ClusteredVmBase.class).error((Throwable)e, "Unexpected error while performing operation.");
            return null;
        }
    }

    @Override
    public void dumpClassStatistic() throws IOException {
        MonitoringPermission.checkPermission(MonitoringPermission.EXECUTE_PERMISSION);
        IOException error = null;
        boolean supportsDump = this.supportsDumpOperations();
        if (supportsDump) {
            try {
                this.performOperationVoid(MonitorOperation.GET_CLASS_STATISTIC, "false", DUMP);
            }
            catch (IOException e) {
                error = e;
            }
        }
        if (!(supportsDump && error == null || this.dumpClassStatisticFallback(false))) {
            throw error == null ? new IOException(DUMP_CLUSTER_ERR) : error;
        }
    }

    @Override
    public void dumpDetailedClassStatistic() throws IOException {
        MonitoringPermission.checkPermission(MonitoringPermission.EXECUTE_PERMISSION);
        IOException error = null;
        boolean supportsDump = this.supportsDumpOperations();
        if (supportsDump) {
            try {
                this.performOperationVoid(MonitorOperation.GET_CLASS_STATISTIC, "true", DUMP);
            }
            catch (IOException e) {
                error = e;
            }
        }
        if (!(supportsDump && error == null || this.dumpClassStatisticFallback(true))) {
            throw error == null ? new IOException(DUMP_CLUSTER_ERR) : error;
        }
    }

    @Override
    public List<String> getClassStatistic() throws IOException {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        return this.performOperation(MonitorOperation.GET_CLASS_STATISTIC, "false");
    }

    @Override
    public List<String> getDetailedClassStatistic() throws IOException {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        return this.performOperation(MonitorOperation.GET_CLASS_STATISTIC, "true");
    }

    @Override
    public void dumpDllInformation() throws IOException {
        MonitoringPermission.checkPermission(MonitoringPermission.EXECUTE_PERMISSION);
        IOException error = null;
        boolean supportsDump = this.supportsDumpOperations();
        if (supportsDump) {
            try {
                this.performOperationVoid(MonitorOperation.GET_DLL_INFO, DUMP);
            }
            catch (IOException e) {
                error = e;
            }
        }
        if (!(supportsDump && error == null || this.dumpDllInformationFallback())) {
            throw error == null ? new IOException(DUMP_CLUSTER_ERR) : error;
        }
    }

    @Override
    public List<String> getDllInformation() throws IOException {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        return this.performOperation(MonitorOperation.GET_DLL_INFO, new String[0]);
    }

    @Override
    public void dumpCodeblobs(String methodName, boolean showDetails) throws IOException {
        MonitoringPermission.checkPermission(MonitoringPermission.EXECUTE_PERMISSION);
        IOException error = null;
        boolean supportsDump = this.supportsDumpOperations();
        if (supportsDump) {
            try {
                this.performOperationVoid(MonitorOperation.GET_CODE_BLOBS, methodName, showDetails ? "true" : "false", DUMP);
            }
            catch (IOException e) {
                error = e;
            }
        }
        if (!(supportsDump && error == null || this.dumpCodeblobsFallback(methodName, showDetails))) {
            throw error == null ? new IOException(DUMP_CLUSTER_ERR) : error;
        }
    }

    @Override
    public List<String> getCodeblobs(String methodName, boolean showDetails) throws IOException {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        return this.performOperation(MonitorOperation.GET_CODE_BLOBS, methodName, showDetails ? "true" : "false");
    }

    @Override
    public void dumpHsErrorInfo() throws IOException {
        MonitoringPermission.checkPermission(MonitoringPermission.EXECUTE_PERMISSION);
        IOException error = null;
        boolean supportsDump = this.supportsDumpOperations();
        if (supportsDump) {
            try {
                this.performOperationVoid(MonitorOperation.GET_HS_ERROR_INFO, DUMP);
            }
            catch (IOException e) {
                error = e;
            }
        }
        if (!(supportsDump && error == null || this.dumpHsErrorInfoFallback())) {
            throw error == null ? new IOException(DUMP_CLUSTER_ERR) : error;
        }
    }

    @Override
    public List<String> getHsErrorInfo() throws IOException {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        return this.performOperation(MonitorOperation.GET_HS_ERROR_INFO, new String[0]);
    }

    @Override
    public void dumpSymbolInfo() throws IOException {
        MonitoringPermission.checkPermission(MonitoringPermission.EXECUTE_PERMISSION);
        IOException error = null;
        boolean supportsDump = this.supportsDumpOperations();
        if (supportsDump) {
            try {
                this.performOperationVoid(MonitorOperation.GET_SYMBOL_INFO, null, DUMP);
            }
            catch (IOException e) {
                error = e;
            }
        }
        if (!(supportsDump && error == null || this.dumpSymbolInfoFallback())) {
            throw error == null ? new IOException(DUMP_CLUSTER_ERR) : error;
        }
    }

    @Override
    public List<String> getSymbolInfo() throws IOException {
        return this.getSymbolInfo(-1);
    }

    @Override
    public List<String> getSymbolInfo(int maxNumber) throws IOException {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        return this.performOperation(MonitorOperation.GET_SYMBOL_INFO, maxNumber <= 0 ? null : String.valueOf(maxNumber));
    }

    @Override
    public List<String> getFlightrecorder(int numLastEntries) throws IOException {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        return this.performOperation(MonitorOperation.GET_FLIGHT_RECORDER, numLastEntries <= 0 ? null : String.valueOf(numLastEntries));
    }

    @Override
    public void startProfiling() throws InvalidVmException {
    }

    @Override
    public void stopProfiling() throws InvalidVmException {
    }

    @Override
    public boolean supportsOperation(MonitorOperation op) {
        try {
            List<String> asw = this.performOperation(MonitorOperation.HAS_OPERATION, op.getOperationID());
            return asw.size() > 0 && asw.get(0).startsWith("true");
        }
        catch (IOException e) {
            Trace.get(ClusteredVmBase.class).error((Throwable)e, "Unexpected error when checking if Vm supports operation.");
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<String> performOperation(MonitorOperation operation, String ... args) throws IOException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(this.executeAttachOperationReturnStream(operation, args)), "UTF-8"));){
            ArrayList<String> result = new ArrayList<String>();
            String thisLine = null;
            while ((thisLine = br.readLine()) != null) {
                result.add(thisLine);
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        catch (AttachNotSupportedException e) {
            throw new IOException("AttachNotSupportedException when trying to perform operation " + operation.getOperationID() + ".", e);
        }
    }

    public void performOperationVoid(MonitorOperation operation, String ... args) throws IOException {
        try {
            this.executeAttachOperationVoid(operation, args);
        }
        catch (AttachNotSupportedException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    protected abstract InputStream executeAttachOperationReturnStream(MonitorOperation var1, String ... var2) throws AttachNotSupportedException, IOException;

    protected abstract byte[] executeAttachOperationReturnArray(MonitorOperation var1, String ... var2) throws AttachNotSupportedException, IOException;

    protected abstract void executeAttachOperationVoid(MonitorOperation var1, String ... var2) throws AttachNotSupportedException, IOException;

    protected boolean supportsDumpOperations() {
        return true;
    }

    protected boolean printStackDumpFallback(String info) {
        return false;
    }

    protected boolean dumpHeapFallback(String info) {
        return false;
    }

    protected boolean dumpGcHistoryFallback() {
        return false;
    }

    protected boolean dumpClassStatisticFallback(boolean detailed) {
        return false;
    }

    protected boolean dumpDllInformationFallback() {
        return false;
    }

    protected boolean dumpCodeblobsFallback(String methodName, boolean showDetails) {
        return false;
    }

    protected boolean dumpHsErrorInfoFallback() {
        return false;
    }

    protected boolean dumpSymbolInfoFallback() {
        return false;
    }

    private static int[] convertTraceFlagsSetToIndexArray(VmTraceFlagsSet flags) {
        int[] flagsIndices = new int[flags.getNrOfFlagsSet()];
        int i = 0;
        for (VmTraceFlag flag : VmTraceFlag.values()) {
            if (!flags.isSet(flag)) continue;
            flagsIndices[i++] = flag.getNumber();
        }
        return flagsIndices;
    }

    private static VmTraceFlagsSet convertIndexArrayToTraceFlagsSet(int[] flags) {
        VmTraceFlagsSet traceSet = new VmTraceFlagsSet();
        if (flags != null) {
            for (int i = 0; i < flags.length; ++i) {
                traceSet.setFlag(VmTraceFlag.getFlagByNumber(flags[i]));
            }
        }
        return traceSet;
    }

    private static String itoa(int value, int radix, int width) {
        String result = Integer.toString(value, radix).toUpperCase();
        if (result.length() >= width) {
            return result;
        }
        char[] padded = new char[width];
        char[] source = result.toCharArray();
        Arrays.fill(padded, '0');
        int offset = width - source.length;
        for (int i = 0; i < source.length; ++i) {
            padded[offset++] = source[i];
        }
        return new String(padded);
    }

    private static String encodeVm(int vmIndex, int vmUniqueId) {
        String vmIndexPart = ClusteredVmBase.itoa(vmIndex, 16, 8);
        String uuidPart = ClusteredVmBase.itoa(vmUniqueId, 16, 8);
        return vmIndexPart + "-" + uuidPart;
    }
}

