/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.extensions.vm;

import com.sap.jvm.impl.extensions.vm.ClusteredVmBase;
import com.sap.jvm.monitor.MonitoringPermission;
import com.sap.jvm.monitor.cluster.ClusterType;
import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.monitor.vm.MonitorOperation;
import com.sap.jvm.monitor.vm.PortRange;
import com.sap.jvm.monitor.vm.SuspendPolicy;
import com.sap.jvm.tracing.Trace;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import sun.tools.attach.HotSpotVirtualMachine;

public final class ClusteredVmImpl
extends ClusteredVmBase {
    private HotSpotVirtualMachine attachedVm = null;
    private boolean attachFailed = false;
    private boolean supportsDump = false;
    private boolean supportsDumpInitialized = false;

    public ClusteredVmImpl(ClusterType clusterType, int clusterOrProcessId, int vmIndex) {
        super(clusterType, clusterOrProcessId, vmIndex, ClusteredVmImpl.getUniqueId0(ClusterType.getConfigurationIndex(clusterType), clusterOrProcessId, vmIndex), ClusteredVmImpl.getPid0(ClusterType.getConfigurationIndex(clusterType), clusterOrProcessId, vmIndex));
    }

    public ClusteredVmImpl(ClusterType clusterType, int clusterOrProcessId, int vmIndex, int uniqueID) {
        super(clusterType, clusterOrProcessId, vmIndex, uniqueID, ClusteredVmImpl.getPid0(ClusterType.getConfigurationIndex(clusterType), clusterOrProcessId, vmIndex));
    }

    @Override
    public boolean isValid() {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        return ClusteredVmImpl.isValid0(this.getClusterTypeId(), this.clusterOrProcessId, this.vmIndex, this.vmUniqueId);
    }

    @Override
    public byte[] getVmSnapshotRaw() throws InvalidVmException {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        byte[] rawData = ClusteredVmImpl.getVmSnapshot0(this.getClusterTypeId(), this.clusterOrProcessId, this.vmIndex);
        if (rawData == null) {
            throw new InvalidVmException(this);
        }
        return rawData;
    }

    @Override
    public byte[] getMemoryInfoRaw() throws InvalidVmException {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        byte[] rawData = ClusteredVmImpl.getMemoryInfo0(this.getClusterTypeId(), this.clusterOrProcessId, this.vmIndex);
        if (rawData == null) {
            throw new InvalidVmException(this);
        }
        return rawData;
    }

    @Override
    public byte[] getTimeInfoRaw() throws InvalidVmException {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        byte[] rawData = ClusteredVmImpl.getTimeInfo0(this.getClusterTypeId(), this.clusterOrProcessId, this.vmIndex);
        if (rawData == null) {
            throw new InvalidVmException(this);
        }
        return rawData;
    }

    @Override
    public byte[] getStateInfoRaw() throws InvalidVmException {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        byte[] rawData = ClusteredVmImpl.getStateInfo0(this.getClusterTypeId(), this.clusterOrProcessId, this.vmIndex);
        if (rawData == null) {
            throw new InvalidVmException(this);
        }
        return rawData;
    }

    @Override
    public byte[] getStartInfoRaw() throws InvalidVmException {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        byte[] rawData = ClusteredVmImpl.getStartInfo0(this.getClusterTypeId(), this.clusterOrProcessId, this.vmIndex);
        if (rawData == null) {
            throw new InvalidVmException(this);
        }
        return rawData;
    }

    @Override
    public byte[] getDebugInfoRaw() throws InvalidVmException {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        byte[] rawData = ClusteredVmImpl.getDebugInfo0(this.getClusterTypeId(), this.clusterOrProcessId, this.vmIndex);
        if (rawData == null) {
            throw new InvalidVmException(this);
        }
        return rawData;
    }

    @Override
    public byte[] getProfilingInfoRaw() throws InvalidVmException {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        byte[] rawData = ClusteredVmImpl.getProfilingInfo0(this.getClusterTypeId(), this.clusterOrProcessId, this.vmIndex);
        if (rawData == null) {
            throw new InvalidVmException(this);
        }
        return rawData;
    }

    @Override
    public synchronized void setDefaultDebugPortRange(PortRange range) throws InvalidVmException {
        MonitoringPermission.checkPermission(MonitoringPermission.EXECUTE_PERMISSION);
        if (!ClusteredVmImpl.setDefaultDebugPortRange0(this.getClusterTypeId(), this.clusterOrProcessId, this.vmIndex, range.getFromPort(), range.getToPort())) {
            throw new InvalidVmException(this);
        }
    }

    @Override
    public void exit(int exitCode) throws InvalidVmException {
        MonitoringPermission.checkPermission(MonitoringPermission.EXECUTE_PERMISSION);
        if (!ClusteredVmImpl.exit0(this.getClusterTypeId(), this.clusterOrProcessId, this.vmIndex, exitCode)) {
            throw new InvalidVmException(this);
        }
    }

    @Override
    public void forceGc() throws InvalidVmException {
        MonitoringPermission.checkPermission(MonitoringPermission.EXECUTE_PERMISSION);
        if (!ClusteredVmImpl.forceGc0(this.getClusterTypeId(), this.clusterOrProcessId, this.vmIndex)) {
            throw new InvalidVmException(this);
        }
    }

    @Override
    public void forceMaxGc() throws InvalidVmException {
        MonitoringPermission.checkPermission(MonitoringPermission.EXECUTE_PERMISSION);
        if (!ClusteredVmImpl.forceMaxGc0(this.getClusterTypeId(), this.clusterOrProcessId, this.vmIndex)) {
            throw new InvalidVmException(this);
        }
    }

    @Override
    public void dumpSafepointState() throws InvalidVmException {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        if (!ClusteredVmImpl.dumpSafepointState0(this.getClusterTypeId(), this.clusterOrProcessId, this.vmIndex)) {
            throw new InvalidVmException(this);
        }
    }

    @Override
    public void startDebug(SuspendPolicy suspendPolicy) throws InvalidVmException {
        MonitoringPermission.checkPermission(MonitoringPermission.EXECUTE_PERMISSION);
        if (!ClusteredVmImpl.startDebug0(this.getClusterTypeId(), this.clusterOrProcessId, this.vmIndex, suspendPolicy.getIndex(), false)) {
            throw new InvalidVmException(this);
        }
    }

    @Override
    public void startLocalDebug(SuspendPolicy suspendPolicy) throws InvalidVmException {
        MonitoringPermission.checkPermission(MonitoringPermission.EXECUTE_PERMISSION);
        if (!ClusteredVmImpl.startDebug0(this.getClusterTypeId(), this.clusterOrProcessId, this.vmIndex, suspendPolicy.getIndex(), true)) {
            throw new InvalidVmException(this);
        }
    }

    @Override
    public void stopDebug() throws InvalidVmException {
        MonitoringPermission.checkPermission(MonitoringPermission.EXECUTE_PERMISSION);
        if (!ClusteredVmImpl.stopDebug0(this.getClusterTypeId(), this.clusterOrProcessId, this.vmIndex)) {
            throw new InvalidVmException(this);
        }
    }

    @Override
    public boolean attachServerIsStarted() throws InvalidVmException {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        return ClusteredVmImpl.attachServerIsStarted0(this.getClusterTypeId(), this.clusterOrProcessId, this.vmIndex);
    }

    @Override
    public void startAttachServer() throws InvalidVmException {
        MonitoringPermission.checkPermission(MonitoringPermission.EXECUTE_PERMISSION);
        if (!ClusteredVmImpl.startAttachServer0(this.getClusterTypeId(), this.clusterOrProcessId, this.vmIndex)) {
            throw new InvalidVmException(this);
        }
    }

    @Override
    public String getVirtualizationInfo() {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        return ClusteredVmImpl.getVirtualizationInfo0(this.getClusterTypeId(), this.clusterOrProcessId, this.vmIndex);
    }

    @Override
    public void stopCommandLineProfiling() throws InvalidVmException {
        MonitoringPermission.checkPermission(MonitoringPermission.EXECUTE_PERMISSION);
        if (!ClusteredVmImpl.stopCommandLineProfiling0(this.getClusterTypeId(), this.clusterOrProcessId, this.vmIndex)) {
            throw new InvalidVmException(this);
        }
    }

    @Override
    public void setCoreSizeToMax() throws InvalidVmException {
        MonitoringPermission.checkPermission(MonitoringPermission.WRITE_PERMISSION);
        if (!ClusteredVmImpl.setCoreSizeToMax0(this.getClusterTypeId(), this.clusterOrProcessId, this.vmIndex)) {
            throw new InvalidVmException(this);
        }
    }

    @Override
    public void changeCommandLineFlags(String flags) throws InvalidVmException {
        MonitoringPermission.checkPermission(MonitoringPermission.WRITE_PERMISSION);
        if (!ClusteredVmImpl.changeCommandLineFlags0(this.getClusterTypeId(), this.clusterOrProcessId, this.vmIndex, flags)) {
            throw new InvalidVmException(this);
        }
    }

    @Override
    public int[] getTraceFlagsRaw() throws InvalidVmException {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        int[] flags = ClusteredVmImpl.getTraceFlags0(this.getClusterTypeId(), this.clusterOrProcessId, this.vmIndex);
        if (flags == null) {
            throw new InvalidVmException(this);
        }
        return flags;
    }

    @Override
    public void setTraceFlagsRaw(int[] flags, int count) throws InvalidVmException {
        MonitoringPermission.checkPermission(MonitoringPermission.EXECUTE_PERMISSION);
        if (!ClusteredVmImpl.setTraceFlags0(this.getClusterTypeId(), this.clusterOrProcessId, this.vmIndex, flags, count)) {
            throw new InvalidVmException(this);
        }
    }

    @Override
    protected boolean printStackDumpFallback(String info) {
        Trace.get(ClusteredVmImpl.class).debug("Trying printStackDump fallback via cluster API.");
        return ClusteredVmImpl.printStackDump0(this.getClusterTypeId(), this.clusterOrProcessId, this.vmIndex, info);
    }

    @Override
    protected boolean dumpHeapFallback(String info) {
        Trace.get(ClusteredVmImpl.class).debug("Trying dumpHeap fallback via cluster API.");
        return ClusteredVmImpl.dumpHeap0(this.getClusterTypeId(), this.clusterOrProcessId, this.vmIndex, info);
    }

    @Override
    protected boolean dumpGcHistoryFallback() {
        Trace.get(ClusteredVmImpl.class).debug("Trying dumpGcHistory fallback via cluster API.");
        return ClusteredVmImpl.dumpGcHistory0(this.getClusterTypeId(), this.clusterOrProcessId, this.vmIndex);
    }

    @Override
    protected boolean dumpClassStatisticFallback(boolean detailed) {
        Trace.get(ClusteredVmImpl.class).debug("Trying dumpClassStatistic fallback via cluster API.");
        return ClusteredVmImpl.dumpClassStatistic0(this.getClusterTypeId(), this.clusterOrProcessId, this.vmIndex, detailed);
    }

    @Override
    protected boolean dumpDllInformationFallback() {
        Trace.get(ClusteredVmImpl.class).debug("Trying dumpDllInformation fallback via cluster API.");
        return ClusteredVmImpl.dumpDllInfo0(this.getClusterTypeId(), this.clusterOrProcessId, this.vmIndex);
    }

    @Override
    protected boolean dumpCodeblobsFallback(String methodName, boolean showDetails) {
        Trace.get(ClusteredVmImpl.class).debug("Trying dumpCodeblobs fallback via cluster API.");
        return ClusteredVmImpl.dumpCodeBlobs0(this.getClusterTypeId(), this.clusterOrProcessId, this.vmIndex, methodName, showDetails);
    }

    @Override
    protected boolean dumpHsErrorInfoFallback() {
        Trace.get(ClusteredVmImpl.class).debug("Trying dumpHsErrorInfo fallback via cluster API.");
        return ClusteredVmImpl.dumpHsErrorInfo0(this.getClusterTypeId(), this.clusterOrProcessId, this.vmIndex);
    }

    @Override
    protected boolean dumpSymbolInfoFallback() {
        Trace.get(ClusteredVmImpl.class).debug("Trying dumpSymbolInfo fallback via cluster API.");
        return ClusteredVmImpl.dumpSymbolInfo0(this.getClusterTypeId(), this.clusterOrProcessId, this.vmIndex);
    }

    @Override
    protected InputStream executeAttachOperationReturnStream(MonitorOperation operation, String ... args) throws AttachNotSupportedException, IOException {
        return this.executeCommand(operation, args);
    }

    @Override
    protected byte[] executeAttachOperationReturnArray(MonitorOperation operation, String ... args) throws AttachNotSupportedException, IOException {
        try (BufferedInputStream stream = new BufferedInputStream(this.executeCommand(operation, args));){
            int bytesRead;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            while ((bytesRead = stream.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    @Override
    protected void executeAttachOperationVoid(MonitorOperation operation, String ... args) throws AttachNotSupportedException, IOException {
        InputStream is = this.executeCommand(operation, args);
        if (is != null) {
            is.close();
        }
    }

    private synchronized InputStream executeCommand(MonitorOperation operation, String ... args) throws AttachNotSupportedException, IOException {
        HotSpotVirtualMachine myAttachedVm = this.attach();
        return myAttachedVm.executeCommand(operation.getOperationID(), args);
    }

    private synchronized HotSpotVirtualMachine attach() throws AttachNotSupportedException, IOException {
        if (this.attachedVm != null) {
            return this.attachedVm;
        }
        if (this.attachFailed) {
            throw new AttachNotSupportedException("Prior attempt to attach to VM with pid " + this.getPid() + " failed.");
        }
        VirtualMachine hotspotVM = null;
        try {
            hotspotVM = VirtualMachine.attach(Long.toString(this.getPid()));
        }
        catch (AttachNotSupportedException | IOException e) {
            this.attachFailed = true;
            throw e;
        }
        if (!(hotspotVM instanceof HotSpotVirtualMachine)) {
            this.attachFailed = true;
            throw new AttachNotSupportedException("Could not attach to target VM, resulting object is of type " + hotspotVM.getClass());
        }
        this.attachedVm = (HotSpotVirtualMachine)hotspotVM;
        return this.attachedVm;
    }

    @Override
    protected boolean supportsDumpOperations() {
        if (!this.supportsDumpInitialized) {
            try {
                List<String> asw = this.performOperation(MonitorOperation.HAS_OPERATION, "supportdump");
                this.supportsDump = asw.size() > 0 && asw.get(0).startsWith("true");
            }
            catch (IOException e) {
                Trace.get(ClusteredVmImpl.class).error((Throwable)e, "Unexpected error when checking if Vm supports dump operations.");
                this.supportsDump = false;
            }
        }
        this.supportsDumpInitialized = true;
        return this.supportsDump;
    }

    private static native int getUniqueId0(int var0, int var1, int var2);

    private static native long getPid0(int var0, int var1, int var2);

    private static native boolean isValid0(int var0, int var1, int var2, int var3);

    private static native byte[] getVmSnapshot0(int var0, int var1, int var2);

    private static native byte[] getMemoryInfo0(int var0, int var1, int var2);

    private static native byte[] getTimeInfo0(int var0, int var1, int var2);

    private static native byte[] getStateInfo0(int var0, int var1, int var2);

    private static native byte[] getStartInfo0(int var0, int var1, int var2);

    private static native byte[] getDebugInfo0(int var0, int var1, int var2);

    private static native byte[] getProfilingInfo0(int var0, int var1, int var2);

    private static native int[] getTraceFlags0(int var0, int var1, int var2);

    private static native boolean setTraceFlags0(int var0, int var1, int var2, int[] var3, int var4);

    private static native boolean setDefaultDebugPortRange0(int var0, int var1, int var2, int var3, int var4);

    private static native boolean exit0(int var0, int var1, int var2, int var3);

    private static native boolean printStackDump0(int var0, int var1, int var2, String var3);

    private static native boolean dumpHeap0(int var0, int var1, int var2, String var3);

    private static native boolean forceGc0(int var0, int var1, int var2);

    private static native boolean forceMaxGc0(int var0, int var1, int var2);

    private static native boolean dumpGcHistory0(int var0, int var1, int var2);

    private static native boolean dumpClassStatistic0(int var0, int var1, int var2, boolean var3);

    private static native boolean dumpDllInfo0(int var0, int var1, int var2);

    private static native boolean dumpCodeBlobs0(int var0, int var1, int var2, String var3, boolean var4);

    private static native boolean dumpHsErrorInfo0(int var0, int var1, int var2);

    private static native boolean dumpSymbolInfo0(int var0, int var1, int var2);

    private static native boolean dumpSafepointState0(int var0, int var1, int var2);

    private static native boolean startDebug0(int var0, int var1, int var2, int var3, boolean var4);

    private static native boolean stopDebug0(int var0, int var1, int var2);

    private static native boolean attachServerIsStarted0(int var0, int var1, int var2);

    private static native boolean startAttachServer0(int var0, int var1, int var2);

    private static native String getVirtualizationInfo0(int var0, int var1, int var2);

    private static native boolean stopCommandLineProfiling0(int var0, int var1, int var2);

    private static native boolean setCoreSizeToMax0(int var0, int var1, int var2);

    private static native boolean changeCommandLineFlags0(int var0, int var1, int var2, String var3);
}

