/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.extensions.vm;

import com.sap.jvm.extension.java.base.NativeOutOfMemoryContext;
import com.sap.jvm.impl.extensions.WithExtensionsNativeLib;
import com.sap.jvm.impl.extensions.vm.ErrorQueueEntryImpl;
import com.sap.jvm.impl.extensions.vm.OutOfMemoryErrorContextImpl;
import com.sap.jvm.monitor.MonitoringPermission;
import com.sap.jvm.monitor.vm.ErrorQueue;
import com.sap.jvm.monitor.vm.ErrorQueueEntry;
import java.security.AccessController;
import java.security.PrivilegedAction;

public final class ErrorQueueImpl
extends ErrorQueue {
    private final Object[] errorQueue;
    private static boolean isQueueInUse;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ErrorQueueImpl() {
        MonitoringPermission.checkPermission(MonitoringPermission.EXECUTE_PERMISSION);
        Class<ErrorQueueImpl> clazz = ErrorQueueImpl.class;
        synchronized (ErrorQueueImpl.class) {
            if (isQueueInUse) {
                throw new IllegalStateException("Error Queue already in use");
            }
            MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
            this.errorQueue = AccessController.doPrivileged(new PrivilegedAction<Object[]>(){

                @Override
                public Object[] run() {
                    return ErrorQueueImpl.getErrorQueue0();
                }
            });
            isQueueInUse = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private ErrorQueueEntry reallyPoll() {
        if (this.errorQueue[0] != null) {
            Throwable t = (Throwable)this.errorQueue[0];
            int elementsRemoved = 1;
            OutOfMemoryErrorContextImpl c = null;
            if (this.errorQueue.length > 1 && t instanceof OutOfMemoryError && this.errorQueue[1] instanceof NativeOutOfMemoryContext) {
                c = OutOfMemoryErrorContextImpl.get((NativeOutOfMemoryContext)this.errorQueue[1]);
                ++elementsRemoved;
            }
            System.arraycopy(this.errorQueue, elementsRemoved, this.errorQueue, 0, this.errorQueue.length - elementsRemoved);
            for (int i = this.errorQueue.length - elementsRemoved; i < this.errorQueue.length; ++i) {
                this.errorQueue[i] = null;
            }
            return new ErrorQueueEntryImpl(t, c);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ErrorQueueEntry poll() {
        if (this.errorQueue == null) {
            return null;
        }
        Object[] objectArray = this.errorQueue;
        synchronized (this.errorQueue) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.reallyPoll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ErrorQueueEntry remove(long timeout) throws IllegalArgumentException, InterruptedException {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Negative timeout value");
        }
        if (this.errorQueue == null) {
            Object lock;
            Object object = lock = new Object();
            synchronized (object) {
                lock.wait(timeout);
            }
            return null;
        }
        Object[] objectArray = this.errorQueue;
        synchronized (this.errorQueue) {
            ErrorQueueEntry e = this.reallyPoll();
            if (e != null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return e;
            }
            do {
                this.errorQueue.wait(timeout);
                e = this.reallyPoll();
                if (e == null) continue;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return e;
            } while (timeout == 0L);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return null;
        }
    }

    private static native Object[] getErrorQueue0();

    static {
        WithExtensionsNativeLib.load();
        isQueueInUse = false;
        new NativeOutOfMemoryContext();
        new OutOfMemoryErrorContextImpl();
        new ErrorQueueEntryImpl(null, null);
    }
}

