/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.extensions.vm;

import com.sap.jvm.impl.extensions.vm.MonitorInfoImpl;
import com.sap.jvm.impl.extensions.vm.ThreadSnapshotImpl;
import com.sap.jvm.impl.monitor.vm.VmDebugInfoImpl;
import com.sap.jvm.impl.monitor.vm.VmMemoryInfoImpl;
import com.sap.jvm.impl.monitor.vm.VmStartInfoImpl;
import com.sap.jvm.impl.monitor.vm.VmStateInfoImpl;
import com.sap.jvm.impl.monitor.vm.VmTimeInfoImpl;
import com.sap.jvm.monitor.vm.ExtendedVmSnapshot;
import com.sap.jvm.monitor.vm.MonitorInfo;
import com.sap.jvm.monitor.vm.ThreadSnapshot;
import com.sap.jvm.monitor.vm.VmDebugInfo;
import com.sap.jvm.monitor.vm.VmMemoryInfo;
import com.sap.jvm.monitor.vm.VmStartInfo;
import com.sap.jvm.monitor.vm.VmStateInfo;
import com.sap.jvm.monitor.vm.VmTimeInfo;
import java.io.DataInputStream;
import java.io.IOException;

public class ExtendedVmSnapshotImpl
implements ExtendedVmSnapshot {
    private final ThreadSnapshot[] threadSnapshots;
    private final MonitorInfo[] monitorInfos;
    private final VmMemoryInfo memoryInfo;
    private final VmTimeInfo timeInfo;
    private final VmStateInfo stateInfo;
    private final VmStartInfo startInfo;
    private final VmDebugInfo debugInfo;

    public ExtendedVmSnapshotImpl(DataInputStream stream) throws IOException {
        this.threadSnapshots = ThreadSnapshotImpl.readThreadSnapshots(stream);
        this.monitorInfos = MonitorInfoImpl.readMonitorInfos(stream);
        this.memoryInfo = new VmMemoryInfoImpl(stream);
        this.timeInfo = new VmTimeInfoImpl(stream);
        this.stateInfo = new VmStateInfoImpl(stream);
        this.startInfo = new VmStartInfoImpl(stream);
        this.debugInfo = new VmDebugInfoImpl(stream);
    }

    @Override
    public ThreadSnapshot[] getAllThreadSnapshots() {
        return (ThreadSnapshot[])this.threadSnapshots.clone();
    }

    @Override
    public MonitorInfo[] getMonitorInfo() {
        return (MonitorInfo[])this.monitorInfos.clone();
    }

    @Override
    public VmMemoryInfo getMemoryInfo() {
        return this.memoryInfo;
    }

    @Override
    public VmTimeInfo getTimeInfo() {
        return this.timeInfo;
    }

    @Override
    public VmStateInfo getStateInfo() {
        return this.stateInfo;
    }

    @Override
    public VmStartInfo getStartInfo() {
        return this.startInfo;
    }

    @Override
    public VmDebugInfo getDebugInfo() {
        return this.debugInfo;
    }
}

