/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.extensions.vm;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Date;

public final class HeapDumpInfo {
    private static final int MAGIC_NUMBER = 1245795905;
    private static final int HPROF_UTF8 = 1;
    private static final String[] VERSIONS = new String[]{" PROFILE 1.0\u0000", " PROFILE 1.0.1\u0000", " PROFILE 1.0.2\u0000"};
    private String filename;

    public HeapDumpInfo(String filename) {
        this.filename = filename;
    }

    private int readVersionHeader(DataInputStream dis) throws IOException {
        int candidatesLeft = VERSIONS.length;
        boolean[] matched = new boolean[VERSIONS.length];
        for (int i = 0; i < candidatesLeft; ++i) {
            matched[i] = true;
        }
        int pos = 0;
        while (candidatesLeft > 0) {
            char c = (char)dis.readByte();
            for (int i = 0; i < VERSIONS.length; ++i) {
                if (!matched[i]) continue;
                if (c != VERSIONS[i].charAt(pos)) {
                    matched[i] = false;
                    --candidatesLeft;
                    continue;
                }
                if (pos != VERSIONS[i].length() - 1) continue;
                return i;
            }
            ++pos;
        }
        throw new IOException("Version string not recognized at byte " + (pos + 3));
    }

    public String getInformation() throws IOException {
        DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(this.filename)));
        int i = dis.readInt();
        if (i != 1245795905) {
            dis.close();
            throw new IOException("Wrong magic number");
        }
        this.readVersionHeader(dis);
        int identifierSize = dis.readInt();
        if (identifierSize != 4 && identifierSize != 8) {
            dis.close();
            throw new IOException("Wrong identifier size of " + identifierSize + ".");
        }
        String info = "Dump file created " + new Date(dis.readLong()) + "\n";
        while (true) {
            int type;
            try {
                type = dis.readUnsignedByte();
            }
            catch (EOFException ignored) {
                break;
            }
            dis.readInt();
            int length = dis.readInt();
            if (type == 1) {
                if (identifierSize == 4) {
                    dis.readInt();
                } else {
                    dis.readLong();
                }
                byte[] chars = new byte[length - identifierSize];
                dis.readFully(chars);
                info = info + new String(chars);
                break;
            }
            dis.skipBytes(length);
        }
        dis.close();
        return info;
    }
}

