/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.extensions.vm;

import com.sap.jvm.monitor.vm.MonitorInfo;
import com.sap.jvm.monitor.vm.VmInfo;
import java.io.DataInputStream;
import java.io.IOException;

public class MonitorInfoImpl
implements MonitorInfo {
    private final String monitorName;
    private final long address;
    private final long owner;
    private final long[] lockingThreads;
    private final long[] waitingThreads;

    public static MonitorInfoImpl[] readMonitorInfos(DataInputStream stream) throws IOException {
        int nrOfMonitors = stream.readInt();
        MonitorInfoImpl[] result = new MonitorInfoImpl[nrOfMonitors];
        for (int i = 0; i < nrOfMonitors; ++i) {
            result[i] = new MonitorInfoImpl(stream);
        }
        return result;
    }

    MonitorInfoImpl(DataInputStream stream) throws IOException {
        this.monitorName = stream.readUTF();
        this.address = stream.readLong();
        this.owner = stream.readLong();
        int nrOfLockingThreads = stream.readInt();
        this.lockingThreads = new long[nrOfLockingThreads];
        for (int i = 0; i < nrOfLockingThreads; ++i) {
            this.lockingThreads[i] = stream.readLong();
        }
        int nrOfWaitingThreads = stream.readInt();
        this.waitingThreads = new long[nrOfWaitingThreads];
        for (int i = 0; i < nrOfWaitingThreads; ++i) {
            this.waitingThreads[i] = stream.readLong();
        }
    }

    @Override
    public String getMonitorName() {
        return this.monitorName;
    }

    @Override
    public long getAddress() {
        return this.address;
    }

    @Override
    public long getOwner() {
        return this.owner;
    }

    @Override
    public String getOwnerAsString() {
        if (this.owner == -1L) {
            return null;
        }
        return VmInfo.getThreadStateInfo(this.owner).getThreadName();
    }

    @Override
    public long[] getWaitingThreads() {
        return (long[])this.waitingThreads.clone();
    }

    @Override
    public String[] getWaitingThreadsAsString() {
        return MonitorInfoImpl.getIdsAsStrings(this.waitingThreads);
    }

    @Override
    public long[] getLockingThreads() {
        return (long[])this.lockingThreads.clone();
    }

    @Override
    public String[] getLockingThreadsAsString() {
        return MonitorInfoImpl.getIdsAsStrings(this.lockingThreads);
    }

    private static String[] getIdsAsStrings(long[] ids) {
        String[] result = new String[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            result[i] = VmInfo.getThreadStateInfo(ids[i]).getThreadName();
        }
        return result;
    }
}

