/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.extensions.vm;

import com.sap.jvm.monitor.vm.ThreadAnnotation;
import com.sap.jvm.monitor.vm.ThreadAnnotationKey;
import com.sap.jvm.monitor.vm.ThreadAppInfo;
import java.io.DataInputStream;
import java.io.IOException;

public class ThreadAppInfoImpl
implements ThreadAppInfo {
    private final AnnotationImpl[] annotations;
    private final String user;
    private final String sessionId;
    private final String requestId;
    private final String appName;
    private final short tag;

    public ThreadAppInfoImpl(DataInputStream stream) throws IOException {
        int nrOfPairs = stream.readInt();
        this.annotations = new AnnotationImpl[nrOfPairs];
        String key = null;
        String value = null;
        ThreadAnnotationKey annotationKey = null;
        String tmpUser = null;
        String tmpRequestId = null;
        String tmpSessionId = null;
        String tmpAppName = null;
        for (int i = 0; i < nrOfPairs; ++i) {
            key = stream.readUTF();
            value = stream.readUTF();
            annotationKey = ThreadAnnotationKey.get(key);
            if (annotationKey == ThreadAnnotationKey.USER) {
                tmpUser = value;
            } else if (annotationKey == ThreadAnnotationKey.SESSION) {
                tmpSessionId = value;
            } else if (annotationKey == ThreadAnnotationKey.REQUEST) {
                tmpRequestId = value;
            } else if (annotationKey == ThreadAnnotationKey.APPLICATION) {
                tmpAppName = value;
            }
            this.annotations[i] = new AnnotationImpl(annotationKey, value);
        }
        this.user = tmpUser;
        this.sessionId = tmpSessionId;
        this.requestId = tmpRequestId;
        this.appName = tmpAppName;
        this.tag = stream.readShort();
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public String getRequestId() {
        return this.requestId;
    }

    @Override
    public String getApplicationName() {
        return this.appName;
    }

    @Override
    @Deprecated
    public String getComponentName() {
        return null;
    }

    public AnnotationImpl[] getAnnotations() {
        return this.annotations;
    }

    @Override
    public short getThreadTag() {
        return this.tag;
    }

    public int hashCode() {
        int hashCode = 255;
        hashCode ^= this.getThreadTag();
        for (int i = 0; i < this.annotations.length; ++i) {
            hashCode ^= this.annotations[i].hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().equals(this.getClass())) {
            ThreadAppInfoImpl tmp = (ThreadAppInfoImpl)obj;
            if (tmp.getThreadTag() != this.getThreadTag()) {
                return false;
            }
            if (tmp.annotations.length != this.annotations.length) {
                return false;
            }
            for (int i = 0; i < this.annotations.length; ++i) {
                if (this.annotations[i].equals(tmp.annotations[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ThreadAppInfoImpl [");
        buffer.append("allocation identifier=\"");
        buffer.append(this.getThreadTag());
        buffer.append("\"");
        for (int i = 0; i < this.annotations.length; ++i) {
            buffer.append(this.annotations[i].key);
            buffer.append("=\"");
            buffer.append(this.annotations[i].value);
            buffer.append("\"");
        }
        buffer.append("]");
        return buffer.toString();
    }

    private static class AnnotationImpl
    implements ThreadAnnotation.Annotation {
        ThreadAnnotationKey key;
        String value;

        public AnnotationImpl(ThreadAnnotationKey key, String value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public ThreadAnnotationKey getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public int hashCode() {
            int hashCode = 255;
            hashCode ^= this.key.hashCode();
            if (this.value != null) {
                hashCode ^= this.value.hashCode();
            }
            return hashCode;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj.getClass().equals(this.getClass())) {
                ThreadAnnotation.Annotation tmp = (ThreadAnnotation.Annotation)obj;
                if (!this.key.equals(tmp.getKey())) {
                    return false;
                }
                if (this.value == null && tmp.getValue() == null) {
                    return true;
                }
                if (this.value != null && this.value.equals(tmp.getValue())) {
                    return true;
                }
            }
            return false;
        }
    }
}

