/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.extensions.vm;

import com.sap.jvm.monitor.vm.ThreadIoInfo;
import java.io.DataInputStream;
import java.io.IOException;

public class ThreadIoInfoImpl
implements ThreadIoInfo {
    private final long fileBytesRead;
    private final long fileBytesWritten;
    private final long networkBytesRead;
    private final long networkBytesWritten;
    private final long numberOfFilesOpened;
    private final long numberOfSocketsOpened;

    public String toString() {
        return "Thread IO statistics: \nfileBytesRead : " + this.fileBytesRead + "\nfileBytesWritten : " + this.fileBytesWritten + "\nnetworkBytesRead : " + this.networkBytesRead + "\nnetworkBytesWritten : " + this.networkBytesWritten + "\nnumberOfFilesOpened : " + this.numberOfFilesOpened + "\nnumberOfSocketsOpened : " + this.numberOfSocketsOpened + "\n";
    }

    public ThreadIoInfoImpl(DataInputStream stream) throws IOException {
        this.fileBytesRead = stream.readLong();
        this.fileBytesWritten = stream.readLong();
        this.networkBytesRead = stream.readLong();
        this.networkBytesWritten = stream.readLong();
        this.numberOfFilesOpened = stream.readLong();
        this.numberOfSocketsOpened = stream.readLong();
    }

    @Override
    public long getFileBytesRead() {
        return this.fileBytesRead;
    }

    @Override
    public long getFileBytesWritten() {
        return this.fileBytesWritten;
    }

    @Override
    public long getNetworkBytesRead() {
        return this.networkBytesRead;
    }

    @Override
    public long getNetworkBytesWritten() {
        return this.networkBytesWritten;
    }

    @Override
    @Deprecated
    public long getOtherBytesRead() {
        return -1L;
    }

    @Override
    @Deprecated
    public long getOtherBytesWritten() {
        return -1L;
    }

    @Override
    public long getNumberOfFilesOpened() {
        return this.numberOfFilesOpened;
    }

    @Override
    @Deprecated
    public long getNumberOfFilesStillOpen() {
        return -1L;
    }

    @Override
    public long getNumberOfSocketsOpened() {
        return this.numberOfSocketsOpened;
    }

    @Override
    @Deprecated
    public long getNumberOfSocketsStillOpen() {
        return -1L;
    }

    @Override
    @Deprecated
    public long getNetworkBytesReceived() {
        return this.getNetworkBytesRead();
    }

    @Override
    @Deprecated
    public long getNetworkBytesSent() {
        return this.getNetworkBytesWritten();
    }
}

