/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.extensions.vm;

import com.sap.jvm.impl.extensions.vm.ThreadAppInfoImpl;
import com.sap.jvm.impl.extensions.vm.ThreadIoInfoImpl;
import com.sap.jvm.impl.extensions.vm.ThreadMemoryInfoImpl;
import com.sap.jvm.impl.extensions.vm.ThreadStateInfoImpl;
import com.sap.jvm.impl.extensions.vm.ThreadTimeInfoImpl;
import com.sap.jvm.monitor.vm.ThreadAppInfo;
import com.sap.jvm.monitor.vm.ThreadIoInfo;
import com.sap.jvm.monitor.vm.ThreadMemoryInfo;
import com.sap.jvm.monitor.vm.ThreadSnapshot;
import com.sap.jvm.monitor.vm.ThreadStateInfo;
import com.sap.jvm.monitor.vm.ThreadTimeInfo;
import java.io.DataInputStream;
import java.io.IOException;

public class ThreadSnapshotImpl
implements ThreadSnapshot {
    private final long threadId;
    private final ThreadTimeInfo timeInfo;
    private final ThreadMemoryInfo memoryInfo;
    private final ThreadStateInfo stateInfo;
    private final ThreadAppInfo appInfo;
    private final ThreadIoInfo ioInfo;

    public static ThreadSnapshotImpl[] readThreadSnapshots(DataInputStream stream) throws IOException {
        int nrOfThreads = stream.readInt();
        ThreadSnapshotImpl[] result = new ThreadSnapshotImpl[nrOfThreads];
        for (int i = 0; i < nrOfThreads; ++i) {
            result[i] = new ThreadSnapshotImpl(stream);
        }
        return result;
    }

    public ThreadSnapshotImpl(DataInputStream stream) throws IOException {
        this.threadId = stream.readLong();
        this.timeInfo = new ThreadTimeInfoImpl(stream);
        this.memoryInfo = new ThreadMemoryInfoImpl(stream);
        this.stateInfo = new ThreadStateInfoImpl(stream);
        this.appInfo = new ThreadAppInfoImpl(stream);
        this.ioInfo = new ThreadIoInfoImpl(stream);
    }

    @Override
    public long getThreadId() {
        return this.threadId;
    }

    @Override
    public ThreadTimeInfo getThreadTimeInfo() {
        return this.timeInfo;
    }

    @Override
    public ThreadMemoryInfo getThreadMemoryInfo() {
        return this.memoryInfo;
    }

    @Override
    public ThreadStateInfo getThreadStateInfo() {
        return this.stateInfo;
    }

    @Override
    public ThreadAppInfo getThreadAppInfo() {
        return this.appInfo;
    }

    @Override
    public ThreadIoInfo getThreadIoInfo() {
        return this.ioInfo;
    }
}

