/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.extensions.vm;

import com.sap.jvm.monitor.ExtendedStackTraceElement;
import com.sap.jvm.monitor.vm.ThreadState;
import com.sap.jvm.monitor.vm.ThreadStateInfo;
import java.io.DataInputStream;
import java.io.IOException;

public final class ThreadStateInfoImpl
implements ThreadStateInfo {
    private final String threadName;
    private final ThreadState threadState;
    private final boolean suspended;
    private final ExtendedStackTraceElement[] stackTrace;

    public ThreadStateInfoImpl(DataInputStream stream) throws IOException {
        this.threadName = stream.readUTF();
        this.threadState = ThreadStateInfoImpl.convertIndexToThreadState(stream.readInt());
        this.suspended = stream.readBoolean();
        this.stackTrace = ThreadStateInfoImpl.readStackTrace(stream);
    }

    private static ThreadState convertIndexToThreadState(int index) {
        switch (index) {
            case 0: {
                return ThreadState.RUNNING;
            }
            case 1: {
                return ThreadState.WAITING_FOR_LOCK;
            }
            case 2: {
                return ThreadState.IN_WAIT_WITH_TIMEOUT;
            }
            case 3: {
                return ThreadState.IN_WAIT_WITHOUT_TIMEOUT;
            }
        }
        throw new IllegalArgumentException("Invalid thread state " + index);
    }

    @Override
    public String getThreadName() {
        return this.threadName;
    }

    @Override
    public ThreadState getThreadState() {
        return this.threadState;
    }

    @Override
    public boolean isSuspended() {
        return this.suspended;
    }

    @Override
    public ExtendedStackTraceElement[] getStackTrace() {
        return this.stackTrace;
    }

    public static ExtendedStackTraceElement[] readStackTrace(DataInputStream stream) throws IOException {
        int nrOfElements = stream.readInt();
        ExtendedStackTraceElement[] result = new ExtendedStackTraceElement[nrOfElements];
        for (int i = 0; i < nrOfElements; ++i) {
            String className = stream.readUTF();
            String methodName = stream.readUTF();
            String methodSig = stream.readUTF().replace('/', '.');
            String fileName = stream.readUTF();
            int lineNr = stream.readInt();
            int pcOffset = stream.readInt();
            boolean isNative = stream.readBoolean();
            boolean isCompiled = stream.readBoolean();
            result[i] = new ExtendedStackTraceElement(className, methodName, methodSig, fileName, lineNr, pcOffset, isNative, isCompiled);
        }
        return result;
    }
}

