/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.extensions.vm;

import com.sap.jvm.impl.extensions.WithExtensionsNativeLib;
import com.sap.jvm.impl.extensions.vm.CurrentVmImpl;
import com.sap.jvm.impl.extensions.vm.VmFactoryImpl;
import com.sap.jvm.monitor.MonitoringPermission;
import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.monitor.vm.PortRange;
import com.sap.jvm.monitor.vm.SuspendPolicy;
import com.sap.jvm.monitor.vm.VmDebug;
import com.sap.jvm.tracing.Trace;
import com.sap.jvm.util.ClassFilter;

public final class VmDebugImpl
extends WithExtensionsNativeLib
implements VmDebug.VmDebugInterface {
    private static VmDebugImpl theInstance = new VmDebugImpl();

    @Override
    public void setDefaultDebugPortRange(PortRange range) {
        MonitoringPermission.checkPermission(MonitoringPermission.EXECUTE_PERMISSION);
        try {
            CurrentVmImpl.get().setDefaultDebugPortRange(range);
        }
        catch (InvalidVmException e) {
            Trace.get(VmDebugImpl.class).error((Throwable)e, "Unexpected exception when setting the default port range.");
        }
    }

    @Override
    public boolean attachDebugger(SuspendPolicy suspendPolicy) {
        return this.attachDebugger(-1, -1, suspendPolicy);
    }

    @Override
    public boolean attachDebugger(int port, SuspendPolicy suspendPolicy) {
        return this.attachDebugger(port, port, suspendPolicy);
    }

    @Override
    public boolean attachDebugger(PortRange range, SuspendPolicy suspendPolicy) {
        return this.attachDebugger(range.getFromPort(), range.getToPort(), suspendPolicy);
    }

    private synchronized boolean attachDebugger(int portbegin, int portend, SuspendPolicy suspendPolicy) {
        MonitoringPermission.checkPermission(MonitoringPermission.EXECUTE_PERMISSION);
        return VmDebugImpl.attachDebugger0(portbegin, portend, suspendPolicy.getIndex());
    }

    @Override
    public boolean attachRestrictedDebugger(SuspendPolicy suspendPolicy, ClassFilter classFilter) {
        return this.attachRestrictedDebugger(-1, -1, suspendPolicy, classFilter);
    }

    @Override
    public boolean attachRestrictedDebugger(int port, SuspendPolicy suspendPolicy, ClassFilter classFilter) {
        return this.attachRestrictedDebugger(port, port, suspendPolicy, classFilter);
    }

    @Override
    public boolean attachRestrictedDebugger(PortRange range, SuspendPolicy suspendPolicy, ClassFilter classFilter) {
        return this.attachRestrictedDebugger(range.getFromPort(), range.getToPort(), suspendPolicy, classFilter);
    }

    private synchronized boolean attachRestrictedDebugger(int portbegin, int portend, SuspendPolicy suspendPolicy, ClassFilter classFilter) {
        MonitoringPermission.checkPermission(MonitoringPermission.EXECUTE_PERMISSION);
        return VmDebugImpl.attachRestrictedDebugger0(portbegin, portend, suspendPolicy.getIndex(), classFilter == null ? null : classFilter.getPattern());
    }

    @Override
    public synchronized boolean attachLocalDebugger(SuspendPolicy suspendPolicy) {
        return this.attachLocalDebugger(-1, -1, suspendPolicy);
    }

    @Override
    public boolean attachLocalDebugger(int port, SuspendPolicy suspendPolicy) {
        return this.attachLocalDebugger(port, port, suspendPolicy);
    }

    @Override
    public boolean attachLocalDebugger(PortRange range, SuspendPolicy suspendPolicy) {
        return this.attachLocalDebugger(range.getFromPort(), range.getToPort(), suspendPolicy);
    }

    private synchronized boolean attachLocalDebugger(int portbegin, int portend, SuspendPolicy suspendPolicy) {
        MonitoringPermission.checkPermission(MonitoringPermission.EXECUTE_PERMISSION);
        return VmDebugImpl.attachLocalDebugger0(portbegin, portend, suspendPolicy.getIndex());
    }

    @Override
    public synchronized boolean detachDebugger() {
        MonitoringPermission.checkPermission(MonitoringPermission.EXECUTE_PERMISSION);
        return VmDebugImpl.detachDebugger0();
    }

    @Override
    public boolean isThreadRestricted() {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        MonitoringPermission.checkPermission(MonitoringPermission.EXECUTE_PERMISSION);
        return VmDebugImpl.isCurrentThreadRestricted0();
    }

    @Override
    public boolean isThreadRestricted(long threadId) {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        Thread thread = VmFactoryImpl.get().getThread(threadId);
        return thread == null ? false : VmDebugImpl.isThreadRestricted0(thread);
    }

    @Override
    public boolean isThreadRestricted(Thread thread) {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        if (thread == null) {
            throw new NullPointerException("Thread parameter is null.");
        }
        return VmDebugImpl.isThreadRestricted0(thread);
    }

    @Override
    public boolean addRestrictedDebugThread() {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        MonitoringPermission.checkPermission(MonitoringPermission.WRITE_PERMISSION);
        MonitoringPermission.checkPermission(MonitoringPermission.EXECUTE_PERMISSION);
        if (!VmDebugImpl.isCurrentThreadRestricted0()) {
            return false;
        }
        VmDebugImpl.clearThreadRestricted0();
        return true;
    }

    @Override
    public boolean removeRestrictedDebugThread() {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        MonitoringPermission.checkPermission(MonitoringPermission.WRITE_PERMISSION);
        MonitoringPermission.checkPermission(MonitoringPermission.EXECUTE_PERMISSION);
        if (VmDebugImpl.isCurrentThreadRestricted0()) {
            return false;
        }
        VmDebugImpl.setThreadRestricted0();
        return true;
    }

    public static VmDebugImpl get() {
        return theInstance;
    }

    private VmDebugImpl() {
    }

    private static native boolean attachDebugger0(int var0, int var1, int var2);

    private static native boolean attachRestrictedDebugger0(int var0, int var1, int var2, String var3);

    private static native boolean attachLocalDebugger0(int var0, int var1, int var2);

    private static native boolean detachDebugger0();

    private static native boolean isCurrentThreadRestricted0();

    private static native boolean isThreadRestricted0(Thread var0);

    private static native void setThreadRestricted0();

    private static native void clearThreadRestricted0();
}

