/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.extensions.vm;

import com.sap.jvm.impl.extensions.WithExtensionsNativeLib;
import com.sap.jvm.impl.extensions.vm.ClusteredVmImpl;
import com.sap.jvm.impl.extensions.vm.CurrentVmImpl;
import com.sap.jvm.impl.extensions.vm.ExtendedVmSnapshotImpl;
import com.sap.jvm.impl.extensions.vm.MonitorInfoImpl;
import com.sap.jvm.impl.extensions.vm.ThreadAppInfoImpl;
import com.sap.jvm.impl.extensions.vm.ThreadIoInfoImpl;
import com.sap.jvm.impl.extensions.vm.ThreadMemoryInfoImpl;
import com.sap.jvm.impl.extensions.vm.ThreadSnapshotImpl;
import com.sap.jvm.impl.extensions.vm.ThreadStateInfoImpl;
import com.sap.jvm.impl.extensions.vm.ThreadTimeInfoImpl;
import com.sap.jvm.impl.monitor.cluster.ClusteredVm;
import com.sap.jvm.impl.monitor.thread.DeadlockImpl;
import com.sap.jvm.monitor.MonitoringPermission;
import com.sap.jvm.monitor.cluster.ClusterType;
import com.sap.jvm.monitor.thread.Deadlock;
import com.sap.jvm.monitor.vm.ExtendedVmSnapshot;
import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.monitor.vm.MonitorInfo;
import com.sap.jvm.monitor.vm.ThreadAppInfo;
import com.sap.jvm.monitor.vm.ThreadIoInfo;
import com.sap.jvm.monitor.vm.ThreadMemoryInfo;
import com.sap.jvm.monitor.vm.ThreadSnapshot;
import com.sap.jvm.monitor.vm.ThreadStateInfo;
import com.sap.jvm.monitor.vm.ThreadTimeInfo;
import com.sap.jvm.monitor.vm.Vm;
import com.sap.jvm.monitor.vm.VmDebugInfo;
import com.sap.jvm.monitor.vm.VmFactory;
import com.sap.jvm.monitor.vm.VmMemoryInfo;
import com.sap.jvm.monitor.vm.VmProfilingInfo;
import com.sap.jvm.monitor.vm.VmStartInfo;
import com.sap.jvm.monitor.vm.VmStateInfo;
import com.sap.jvm.monitor.vm.VmTimeInfo;
import com.sap.jvm.tracing.Trace;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class VmFactoryImpl
extends WithExtensionsNativeLib
implements VmFactory.VmFactoryInterface {
    private static final VmFactoryImpl theFactory = new VmFactoryImpl();
    private static final ClusterType MY_CLUSTER_TYPE = VmFactoryImpl.useJvmExtensions0() ? ClusterType.CLUSTER_TYPE_INSTANCE : ClusterType.CLUSTER_TYPE_PROCESS;
    private static final int MY_CLUSTER_OR_PROCESS_ID = VmFactoryImpl.getCurrentClusterId0();

    public static VmFactoryImpl get() {
        return theFactory;
    }

    private VmFactoryImpl() {
    }

    @Override
    public Vm getCurrentVm() {
        return CurrentVmImpl.get();
    }

    public ClusteredVm[] getAllVms() {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        CurrentVmImpl currentVm = CurrentVmImpl.get();
        int maxVms = VmFactoryImpl.getMaxVmsInCurrentCluster0();
        int validVms = 0;
        ClusteredVm[] rawVms = new ClusteredVm[maxVms];
        for (int i = 0; i < maxVms; ++i) {
            if (i == currentVm.getVmIndex()) {
                rawVms[validVms] = currentVm;
                ++validVms;
                continue;
            }
            ClusteredVmImpl actVm = VmFactoryImpl.getVmWithVmIndex(i);
            if (actVm == null) continue;
            rawVms[validVms] = actVm;
            ++validVms;
        }
        ClusteredVm[] result = new ClusteredVm[validVms];
        System.arraycopy(rawVms, 0, result, 0, validVms);
        return result;
    }

    @Override
    public ClusteredVmImpl decodeVmHandle(String encodedVmHandle) {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        if (encodedVmHandle.length() < 10 || encodedVmHandle.charAt(8) != '-') {
            return null;
        }
        String vmIndexPart = encodedVmHandle.substring(0, 8);
        String uniqueIdPart = encodedVmHandle.substring(9);
        try {
            return new ClusteredVmImpl(MY_CLUSTER_TYPE, MY_CLUSTER_OR_PROCESS_ID, Integer.parseInt(vmIndexPart, 16), Integer.parseInt(uniqueIdPart, 16));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public String encodeVmHandle() {
        return CurrentVmImpl.get().encode();
    }

    @Override
    public ExtendedVmSnapshot getVmSnapshot() {
        try {
            return new ExtendedVmSnapshotImpl(new DataInputStream(new ByteArrayInputStream(this.getExtendedVmSnapshotRaw())));
        }
        catch (IOException e) {
            Trace.get(VmFactoryImpl.class).error((Throwable)e, "Unexpected error reading the VM snapshot information.");
            return null;
        }
    }

    @Override
    public VmMemoryInfo getVmMemoryInfo() {
        try {
            return CurrentVmImpl.get().getMemoryInfo();
        }
        catch (InvalidVmException e) {
            Trace.get(VmFactoryImpl.class).error((Throwable)e, "Unexpected error reading the VM memory information.");
            return null;
        }
    }

    @Override
    public VmTimeInfo getVmTimeInfo() {
        try {
            return CurrentVmImpl.get().getTimeInfo();
        }
        catch (InvalidVmException e) {
            Trace.get(VmFactoryImpl.class).error((Throwable)e, "Unexpected error reading the VM time information.");
            return null;
        }
    }

    @Override
    public VmStateInfo getVmStateInfo() {
        try {
            return CurrentVmImpl.get().getStateInfo();
        }
        catch (InvalidVmException e) {
            Trace.get(VmFactoryImpl.class).error((Throwable)e, "Unexpected error reading the VM state information.");
            return null;
        }
    }

    @Override
    public VmStartInfo getVmStartInfo() {
        try {
            return CurrentVmImpl.get().getStartInfo();
        }
        catch (InvalidVmException e) {
            Trace.get(VmFactoryImpl.class).error((Throwable)e, "Unexpected error reading the VM start information.");
            return null;
        }
    }

    @Override
    public VmDebugInfo getVmDebugInfo() {
        try {
            return CurrentVmImpl.get().getDebugInfo();
        }
        catch (InvalidVmException e) {
            Trace.get(VmFactoryImpl.class).error((Throwable)e, "Unexpected error reading the VM debug information.");
            return null;
        }
    }

    @Override
    public VmProfilingInfo getVmProfilingInfo() {
        try {
            return CurrentVmImpl.get().getProfilingInfo();
        }
        catch (InvalidVmException e) {
            Trace.get(VmFactoryImpl.class).error((Throwable)e, "Unexpected error reading the VM profiling information.");
            return null;
        }
    }

    @Override
    public long[] getAllThreadIds() {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        Thread[] threads = VmFactoryImpl.getAllThreads0();
        long[] threadIds = new long[threads.length];
        for (int i = 0; i < threadIds.length; ++i) {
            threadIds[i] = threads[i].getId();
        }
        return threadIds;
    }

    @Override
    public Thread getThread(long threadId) {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        if (threadId == Thread.currentThread().getId()) {
            return Thread.currentThread();
        }
        for (Thread thread : VmFactoryImpl.getAllThreads0()) {
            if (thread.getId() != threadId) continue;
            return thread;
        }
        return null;
    }

    @Override
    public ThreadSnapshot[] getAllThreadSnapshots() {
        try {
            return ThreadSnapshotImpl.readThreadSnapshots(new DataInputStream(new ByteArrayInputStream(this.getAllThreadSnapshotsRaw())));
        }
        catch (IOException e) {
            Trace.get(VmFactoryImpl.class).error((Throwable)e, "Unexpected exception during reading thread snapshot information.");
            return null;
        }
    }

    @Override
    public ThreadSnapshot getThreadSnapshot(Thread thread) {
        try {
            return new ThreadSnapshotImpl(new DataInputStream(new ByteArrayInputStream(this.getThreadSnapshotRaw(thread))));
        }
        catch (IOException e) {
            Trace.get(VmFactoryImpl.class).error((Throwable)e, "Unexpected exception while reading thread snapshot information.");
            return null;
        }
    }

    @Override
    public ThreadSnapshot getThreadSnapshot(long threadId) {
        return this.getThreadSnapshot(this.getThread(threadId));
    }

    @Override
    public ThreadTimeInfo getThreadTimeInfo(Thread thread) {
        try {
            return new ThreadTimeInfoImpl(new DataInputStream(new ByteArrayInputStream(this.getThreadTimeInfoRaw(thread))));
        }
        catch (IOException e) {
            Trace.get(VmFactoryImpl.class).error((Throwable)e, "Unexpected exception while reading thread timeinformation.");
            return null;
        }
    }

    @Override
    public ThreadTimeInfo getThreadTimeInfo(long threadId) {
        return this.getThreadTimeInfo(this.getThread(threadId));
    }

    @Override
    public ThreadMemoryInfo getThreadMemoryInfo(Thread thread) {
        try {
            return new ThreadMemoryInfoImpl(new DataInputStream(new ByteArrayInputStream(this.getThreadMemoryInfoRaw(thread))));
        }
        catch (IOException e) {
            Trace.get(VmFactoryImpl.class).error((Throwable)e, "Unexpected exception while reading thread memory information.");
            return null;
        }
    }

    @Override
    public ThreadMemoryInfo getThreadMemoryInfo(long threadId) {
        return this.getThreadMemoryInfo(this.getThread(threadId));
    }

    @Override
    public ThreadStateInfo getThreadStateInfo(Thread thread) {
        try {
            return new ThreadStateInfoImpl(new DataInputStream(new ByteArrayInputStream(this.getThreadStateInfoRaw(thread))));
        }
        catch (IOException e) {
            Trace.get(VmFactoryImpl.class).error((Throwable)e, "Unexpected exception while reading thread state information.");
            return null;
        }
    }

    @Override
    public ThreadStateInfo getThreadStateInfo(long threadId) {
        return this.getThreadStateInfo(this.getThread(threadId));
    }

    @Override
    public ThreadAppInfo getThreadAppInfo(Thread thread) {
        try {
            return new ThreadAppInfoImpl(new DataInputStream(new ByteArrayInputStream(this.getThreadAppInfoRaw(thread))));
        }
        catch (IOException e) {
            Trace.get(VmFactoryImpl.class).error((Throwable)e, "Unexpected exception while reading thread application information.");
            return null;
        }
    }

    @Override
    public ThreadAppInfo getThreadAppInfo(long threadId) {
        return this.getThreadAppInfo(this.getThread(threadId));
    }

    @Override
    public ThreadIoInfo getThreadIoInfo(Thread thread) {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        if (thread == null) {
            return null;
        }
        byte[] threadIoInfoRaw = VmFactoryImpl.getThreadIoInfo0(thread);
        if (threadIoInfoRaw == null) {
            Trace.get(VmFactoryImpl.class).error(() -> "Call to getThreadIoInfo0 for thread " + thread + " returned null.");
            return null;
        }
        try {
            return new ThreadIoInfoImpl(new DataInputStream(new ByteArrayInputStream(threadIoInfoRaw)));
        }
        catch (IOException e) {
            Trace.get(VmFactoryImpl.class).error((Throwable)e, "Unexpected exception while reading thread Io statistics.");
            return null;
        }
    }

    @Override
    public ThreadIoInfo getThreadIoInfo(long threadId) {
        return this.getThreadIoInfo(this.getThread(threadId));
    }

    @Override
    public long[] getCurrentThreadNetworkTraffic() {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        long[] values = new long[2];
        return (long[])(VmFactoryImpl.getCurrentThreadNetworkTraffic0(values) ? values : null);
    }

    @Override
    public void resetThreadStackDumpCounters() {
        MonitoringPermission.checkPermission(MonitoringPermission.EXECUTE_PERMISSION);
        VmFactoryImpl.resetStatistics0(Thread.currentThread());
    }

    @Override
    public short getThreadTag() {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        return VmFactoryImpl.getTagForCurrentThread0();
    }

    @Override
    public short getThreadTag(Thread thread) {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        if (thread == null) {
            throw new NullPointerException("The parameter \"thread\" is null.");
        }
        return VmFactoryImpl.getTagForThread0(thread);
    }

    @Override
    public short getThreadTag(long threadId) {
        return this.getThreadTag(this.getThread(threadId));
    }

    @Override
    public void setThreadTag(short tag) {
        MonitoringPermission.checkPermission(MonitoringPermission.WRITE_PERMISSION);
        VmFactoryImpl.setTagForCurrentThread0(tag);
    }

    @Override
    public void setThreadTag(Thread thread, short tag) {
        MonitoringPermission.checkPermission(MonitoringPermission.WRITE_PERMISSION);
        if (thread == null) {
            throw new NullPointerException("The parameter \"thread\" is null.");
        }
        VmFactoryImpl.setTagForThread0(thread, tag);
    }

    @Override
    public void setThreadTag(long threadId, short tag) {
        this.setThreadTag(Thread.currentThread(), tag);
    }

    @Override
    public Deadlock[] findDeadlocks() {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        try {
            return DeadlockImpl.readDeadlocks(new DataInputStream(new ByteArrayInputStream(VmFactoryImpl.findDeadlocks0())));
        }
        catch (IOException e) {
            Trace.get(VmFactoryImpl.class).error((Throwable)e, "Unexpected exception during reading deadlocks.");
            return new Deadlock[0];
        }
    }

    @Override
    public MonitorInfo[] getMonitorInfo() {
        try {
            return MonitorInfoImpl.readMonitorInfos(new DataInputStream(new ByteArrayInputStream(this.getMonitorInfoRaw())));
        }
        catch (IOException e) {
            Trace.get(VmFactoryImpl.class).error((Throwable)e, "Unexpected exception during reading monitor information.");
            return null;
        }
    }

    public byte[] getExtendedVmSnapshotRaw() {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        return VmFactoryImpl.getExtendedVmSnapshot0();
    }

    public byte[] getAllThreadSnapshotsRaw() {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        return VmFactoryImpl.getAllThreadSnapshots0();
    }

    public byte[] getThreadSnapshotRaw(Thread thread) {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        if (thread == null) {
            return null;
        }
        return VmFactoryImpl.getThreadSnapshot0(thread);
    }

    public byte[] getThreadTimeInfoRaw(Thread thread) {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        if (thread == null) {
            return null;
        }
        return VmFactoryImpl.getThreadTimeInfo0(thread);
    }

    public byte[] getThreadMemoryInfoRaw(Thread thread) {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        if (thread == null) {
            return null;
        }
        return VmFactoryImpl.getThreadMemoryInfo0(thread);
    }

    public byte[] getThreadStateInfoRaw(Thread thread) {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        if (thread == null) {
            return null;
        }
        return VmFactoryImpl.getThreadStateInfo0(thread);
    }

    public byte[] getThreadAppInfoRaw(Thread thread) {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        if (thread == null) {
            return null;
        }
        return VmFactoryImpl.getThreadAppInfo0(thread);
    }

    public byte[] getMonitorInfoRaw() {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        return VmFactoryImpl.getMonitorInfo0();
    }

    private static ClusteredVmImpl getVmWithVmIndex(int vmIndex) {
        if (!VmFactoryImpl.isVmIndexValidInCurrentCluster0(vmIndex)) {
            return null;
        }
        int vmUniqueId = VmFactoryImpl.getUniqueIdInCurrentCluster0(vmIndex);
        if (vmUniqueId == -1) {
            return null;
        }
        if (!VmFactoryImpl.isVmValidInCurrentCluster0(vmIndex, vmUniqueId)) {
            return null;
        }
        return new ClusteredVmImpl(MY_CLUSTER_TYPE, MY_CLUSTER_OR_PROCESS_ID, vmIndex, vmUniqueId);
    }

    private static native boolean useJvmExtensions0();

    private static native int getCurrentClusterId0();

    private static native int getMaxVmsInCurrentCluster0();

    private static native int getUniqueIdInCurrentCluster0(int var0);

    private static native boolean isVmIndexValidInCurrentCluster0(int var0);

    private static native boolean isVmValidInCurrentCluster0(int var0, int var1);

    private static native byte[] getExtendedVmSnapshot0();

    private static native Thread[] getAllThreads0();

    private static native byte[] getAllThreadSnapshots0();

    private static native byte[] getThreadSnapshot0(Thread var0);

    private static native byte[] getThreadTimeInfo0(Thread var0);

    private static native byte[] getThreadMemoryInfo0(Thread var0);

    private static native byte[] getThreadStateInfo0(Thread var0);

    private static native byte[] getThreadAppInfo0(Thread var0);

    private static native byte[] getThreadIoInfo0(Thread var0);

    private static native boolean getCurrentThreadNetworkTraffic0(long[] var0);

    private static native void resetStatistics0(Thread var0);

    private static native short getTagForCurrentThread0();

    private static native short getTagForThread0(Thread var0);

    private static native void setTagForCurrentThread0(short var0);

    private static native void setTagForThread0(Thread var0, short var1);

    private static native byte[] findDeadlocks0();

    private static native byte[] getMonitorInfo0();
}

