/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.extensions.vm;

import com.sap.jvm.impl.extensions.WithExtensionsNativeLib;
import com.sap.jvm.impl.extensions.vm.CurrentVmImpl;
import com.sap.jvm.impl.extensions.vm.HeapDumpInfo;
import com.sap.jvm.impl.extensions.vm.VmFactoryImpl;
import com.sap.jvm.monitor.MonitoringPermission;
import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.monitor.vm.MonitorOperation;
import com.sap.jvm.monitor.vm.VmTrace;
import com.sap.jvm.monitor.vm.VmTraceFlag;
import com.sap.jvm.monitor.vm.VmTraceFlagsSet;
import com.sap.jvm.monitor.vm.VmTraceMessageClass;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;

public class VmTraceImpl
extends WithExtensionsNativeLib
implements VmTrace.VmTraceInterface {
    private static VmTraceImpl theInstance = new VmTraceImpl();

    @Override
    public VmTraceFlagsSet getTraceFlags() {
        try {
            return CurrentVmImpl.get().getTraceFlags();
        }
        catch (InvalidVmException e) {
            Trace.get(VmTraceImpl.class).error((Throwable)e, "InvalidVmException calling getTraceFlags().");
            return null;
        }
    }

    @Override
    public boolean getTraceFlag(VmTraceFlag flag) {
        return this.getTraceFlags().isSet(flag);
    }

    @Override
    public void setTraceFlags(VmTraceFlagsSet flags) {
        try {
            CurrentVmImpl.get().setTraceFlags(flags);
        }
        catch (InvalidVmException e) {
            Trace.get(VmTraceImpl.class).error((Throwable)e, "InvalidVmException calling setTraceFlags().");
        }
    }

    @Override
    public void setTraceFlag(VmTraceFlag flag) {
        try {
            CurrentVmImpl.get().setTraceFlagsRaw(new int[]{flag.getNumber()}, 1);
        }
        catch (InvalidVmException e) {
            Trace.get(VmTraceImpl.class).error((Throwable)e, "InvalidVmException calling setTraceFlagsRaw().");
        }
    }

    @Override
    public void clearTraceFlag(VmTraceFlag flag) {
        VmTraceImpl.clearTraceFlagRaw(flag.getNumber());
    }

    @Override
    public void setTraceFile(String filename) throws IOException {
        this.setTraceFile(filename, 1, 0);
    }

    @Override
    public void setTraceFile(String filename, int fileCount, int fileMaxSize) throws IOException {
        MonitoringPermission.checkPermission(MonitoringPermission.EXECUTE_PERMISSION);
        if (!VmTraceImpl.setTraceFile0(filename)) {
            throw new IOException("Open trace file " + filename + " failed.");
        }
    }

    @Override
    public void printStackDump(String info) {
        try {
            CurrentVmImpl.get().printStackDump(info);
        }
        catch (IOException e) {
            Trace.get(VmTraceImpl.class).error((Throwable)e, "IOException calling printStackDump().");
        }
    }

    @Override
    public void printStackTrace(Thread thread, String info) {
        MonitoringPermission.checkPermission(MonitoringPermission.EXECUTE_PERMISSION);
        if (thread != null) {
            VmTraceImpl.printStackTrace0(thread, info);
        }
    }

    @Override
    public void printStackTrace(long threadId, String info) {
        this.printStackTrace(VmFactoryImpl.get().getThread(threadId), info);
    }

    @Override
    public String getStackTrace(Thread thread) {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        return thread == null ? null : VmTraceImpl.getStackTrace0(thread);
    }

    @Override
    public String getStackTrace(long threadId) {
        return this.getStackTrace(VmFactoryImpl.get().getThread(threadId));
    }

    @Override
    public void printStackDumpAndHeapDump(String stackInfo, String heapInfo) {
        CurrentVmImpl me = CurrentVmImpl.get();
        try {
            me.printStackDump(stackInfo);
            me.dumpHeap(heapInfo);
        }
        catch (IOException e) {
            Trace.get(VmTraceImpl.class).error((Throwable)e, "IOException dumping stack/heap.");
        }
    }

    @Override
    public void dumpHeap(String filename, boolean doFullGc, String info) {
        MonitoringPermission.checkPermission(MonitoringPermission.EXECUTE_PERMISSION);
        try {
            CurrentVmImpl.get().performOperationVoid(MonitorOperation.DUMP_HEAP, filename, doFullGc ? "-live" : "-all", info);
        }
        catch (IOException e) {
            Trace.get(VmTraceImpl.class).error((Throwable)e, "IOException calling dumpHeap().");
        }
    }

    @Override
    public void dumpHeapIncludingAllocationStatistic(String filename, boolean doFullGc, String info) {
        this.dumpHeap(filename, doFullGc, info);
    }

    @Override
    public String getHeapDumpInformation(String filename) {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        try {
            return new HeapDumpInfo(filename).getInformation();
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Override
    public void forceGc() {
        CurrentVmImpl.get().forceGc();
    }

    @Override
    public void forceMaxGc() {
        CurrentVmImpl.get().forceMaxGc();
    }

    @Override
    public void dumpGcHistory() {
        try {
            CurrentVmImpl.get().dumpGcHistory();
        }
        catch (IOException e) {
            Trace.get(VmTraceImpl.class).error((Throwable)e, "InvalidVmException calling dumpGcHistory().");
        }
    }

    @Override
    public void dumpClassStatistic() {
        try {
            CurrentVmImpl.get().dumpClassStatistic();
        }
        catch (IOException e) {
            Trace.get(VmTraceImpl.class).error((Throwable)e, "InvalidVmException calling dumpClassStatistic().");
        }
    }

    @Override
    public void dumpDetailedClassStatistic() {
        try {
            CurrentVmImpl.get().dumpDetailedClassStatistic();
        }
        catch (IOException e) {
            Trace.get(VmTraceImpl.class).error((Throwable)e, "InvalidVmException calling dumpDetailedClassStatistic().");
        }
    }

    @Override
    public void dumpDllInformation() {
        try {
            CurrentVmImpl.get().dumpDllInformation();
        }
        catch (IOException e) {
            Trace.get(VmTraceImpl.class).error((Throwable)e, "InvalidVmException calling dumpDllInformation().");
        }
    }

    @Override
    public void trace(VmTraceMessageClass cls, VmTraceFlag flag, String text) {
        MonitoringPermission.checkPermission(MonitoringPermission.WRITE_PERMISSION);
        if (this.getTraceFlag(flag)) {
            VmTraceImpl.trace0(cls.getValue(), flag.getNumber(), text);
        }
    }

    public static void clearTraceFlagRaw(int flag) {
        MonitoringPermission.checkPermission(MonitoringPermission.EXECUTE_PERMISSION);
        VmTraceImpl.clearTraceFlags0(new int[]{flag}, 1);
    }

    public static VmTraceImpl get() {
        return theInstance;
    }

    private VmTraceImpl() {
    }

    private static native void printStackTrace0(Thread var0, String var1);

    private static native String getStackTrace0(Thread var0);

    private static native void trace0(int var0, int var1, String var2);

    private static native boolean clearTraceFlags0(int[] var0, int var1);

    private static native boolean setTraceFile0(String var0);
}

