/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.internals;

import com.sap.jvm.impl.monitor.cluster.ClusteredVm;
import com.sap.jvm.internal.InternalAPIFactory;
import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.tracing.Trace;
import java.io.Serializable;

public final class VmSpec
implements Serializable {
    private static final long serialVersionUID = -6136244411245410312L;
    private final int clusterTypeId;
    private final int instanceId;
    private final int vmIndex;
    private final int vmUniqueId;

    public int getClusterTypeId() {
        return this.clusterTypeId;
    }

    public int getClusterId() {
        return this.instanceId;
    }

    public int getVmIndex() {
        return this.vmIndex;
    }

    public int getVmUniqueId() {
        return this.vmUniqueId;
    }

    public VmSpec(int clusterTypeId, int instanceId, int vmIndex, int vmUniqueId) {
        this.clusterTypeId = clusterTypeId;
        this.instanceId = instanceId;
        this.vmIndex = vmIndex;
        this.vmUniqueId = vmUniqueId;
    }

    public static VmSpec getVmSpecByProcessId(int processId) {
        ClusteredVm vm = InternalAPIFactory.getVm(processId);
        if (vm == null) {
            return null;
        }
        try {
            int statePid = vm.getStateInfo().getPid();
            if (statePid == processId) {
                return new VmSpec(vm.getClusterTypeId(), vm.getClusterOrProcessId(), vm.getVmIndex(), vm.getVmUniqueId());
            }
            Trace.get(VmSpec.class).warn(() -> "pid " + processId + " does not match " + statePid + " of vm " + vm);
            return null;
        }
        catch (InvalidVmException e) {
            Trace.get(VmSpec.class).warn((Throwable)e, () -> "could not determine pid of " + vm);
            return null;
        }
    }
}

