/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.monitor.iostat;

import com.sap.jvm.monitor.iostat.IoProbe;
import com.sap.jvm.monitor.iostat.IoStatException;
import com.sap.jvm.monitor.iostat.IoStatType;
import com.sap.jvm.monitor.vm.ThreadIoInfo;
import com.sap.jvm.monitor.vm.VmInfo;

public final class IoProbeImpl
implements IoProbe {
    private final Thread creationThread;
    private final IoStatType type;
    private boolean closed;
    private long resetValue;

    public IoProbeImpl(IoStatType type) throws IoStatException {
        this.type = type;
        this.creationThread = Thread.currentThread();
        this.closed = false;
        this.resetValue = this.getValue();
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public IoStatType getType() {
        return this.type;
    }

    @Override
    public long getValue() throws IoStatException {
        return this.getAbsoluteValue() - this.resetValue;
    }

    private long getAbsoluteValue() throws IoStatException {
        ThreadIoInfo info;
        if (this.closed) {
            throw new IoStatException("Probe closed already");
        }
        if (Thread.currentThread().equals(this.creationThread)) {
            if (this.type.equals((Object)IoStatType.NETIO_BYTES_READ)) {
                long[] networkTraffic = VmInfo.getCurrentThreadNetworkTraffic();
                return networkTraffic[0];
            }
            if (this.type.equals((Object)IoStatType.NETIO_BYTES_WRITTEN)) {
                long[] networkTraffic = VmInfo.getCurrentThreadNetworkTraffic();
                return networkTraffic[1];
            }
        }
        if ((info = VmInfo.getThreadIoInfo(this.creationThread)) == null) {
            throw new IoStatException("");
        }
        switch (this.type) {
            case FILEIO_BYTES_READ: {
                return info.getFileBytesRead();
            }
            case FILEIO_BYTES_WRITTEN: {
                return info.getFileBytesWritten();
            }
            case NETIO_BYTES_READ: {
                return info.getNetworkBytesRead();
            }
            case NETIO_BYTES_WRITTEN: {
                return info.getNetworkBytesWritten();
            }
            case NUM_FILES_OPENED: {
                return info.getNumberOfFilesOpened();
            }
            case NUM_SOCKETS_OPENED: {
                return info.getNumberOfSocketsOpened();
            }
        }
        return 0L;
    }

    @Override
    public void reset() throws IoStatException {
        this.resetValue = this.getValue();
    }

    @Override
    public boolean isDummy() {
        return false;
    }
}

