/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.monitor.os;

import com.sap.jvm.impl.extensions.WithExtensionsNativeLib;
import com.sap.jvm.monitor.MonitoringPermission;

public class OsInfoImpl
extends WithExtensionsNativeLib {
    public static long getTotalSpace(String path) {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("getFileSystemAttributes"));
            sm.checkRead(path);
        }
        return OsInfoImpl.getTotalSpace0(path);
    }

    public static long getFreeSpace(String path) {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("getFileSystemAttributes"));
            sm.checkRead(path);
        }
        return OsInfoImpl.getFreeSpace0(path);
    }

    public static long getUsableSpace(String path) {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("getFileSystemAttributes"));
            sm.checkRead(path);
        }
        return OsInfoImpl.getUsableSpace0(path);
    }

    public static int getServiceByName(String name, String proto) {
        return OsInfoImpl.getServiceByName0(name, proto);
    }

    private static native long getTotalSpace0(String var0);

    private static native long getFreeSpace0(String var0);

    private static native long getUsableSpace0(String var0);

    private static native int getServiceByName0(String var0, String var1);
}

