/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.monitor.remoteCluster;

import com.sap.jvm.impl.monitor.remoteCluster.RemoteVmImpl;
import com.sap.jvm.impl.monitor.remoteCluster.VmImpl;
import com.sap.jvm.monitor.cluster.Cluster;
import com.sap.jvm.monitor.cluster.ClusterInfo;
import com.sap.jvm.monitor.remoteCluster.RemoteCluster;
import com.sap.jvm.monitor.remoteCluster.RemoteVm;
import com.sap.jvm.monitor.vm.Vm;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;

public class RemoteClusterImpl
extends UnicastRemoteObject
implements RemoteCluster {
    private static final long serialVersionUID = -8403518818925056971L;
    private RMIClientSocketFactory csf;
    private RMIServerSocketFactory ssf;

    public RemoteClusterImpl() throws RemoteException {
    }

    public RemoteClusterImpl(RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException {
        super(0, csf, ssf);
        this.csf = csf;
        this.ssf = ssf;
    }

    @Override
    public ClusterInfo[] getClusterInfo() {
        return Cluster.getClusterInfo();
    }

    @Override
    public RemoteVm getVm(int processId) throws RemoteException {
        Vm vm = Cluster.getVm(processId);
        return vm != null ? new RemoteVmImpl(vm, this.csf, this.ssf) : null;
    }

    @Override
    public Vm getVm(RemoteVm vm) {
        return vm != null ? new VmImpl(vm) : null;
    }

    @Override
    public RemoteVm[] getVms(int instanceId) throws RemoteException {
        Vm[] vms = Cluster.getVms(instanceId);
        RemoteVm[] remoteVms = new RemoteVm[vms.length];
        for (int i = 0; i < vms.length; ++i) {
            remoteVms[i] = new RemoteVmImpl(vms[i], this.csf, this.ssf);
        }
        return remoteVms;
    }

    @Override
    public Vm[] getVms(RemoteVm[] vms) {
        Vm[] localVms = new Vm[vms.length];
        for (int i = 0; i < vms.length; ++i) {
            localVms[i] = new VmImpl(vms[i]);
        }
        return localVms;
    }
}

