/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.monitor.remoteCluster;

import com.sap.jvm.monitor.remoteCluster.RemoteVm;
import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.monitor.vm.MonitorOperation;
import com.sap.jvm.monitor.vm.PortRange;
import com.sap.jvm.monitor.vm.SuspendPolicy;
import com.sap.jvm.monitor.vm.Vm;
import com.sap.jvm.monitor.vm.VmDebugInfo;
import com.sap.jvm.monitor.vm.VmMemoryInfo;
import com.sap.jvm.monitor.vm.VmProfilingInfo;
import com.sap.jvm.monitor.vm.VmSnapshot;
import com.sap.jvm.monitor.vm.VmStartInfo;
import com.sap.jvm.monitor.vm.VmStateInfo;
import com.sap.jvm.monitor.vm.VmTimeInfo;
import com.sap.jvm.monitor.vm.VmTraceFlagsSet;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public final class VmImpl
implements Vm,
Serializable {
    private static final long serialVersionUID = 1028496006167063720L;
    private RemoteVm vm;

    public VmImpl(RemoteVm vm) {
        this.vm = vm;
    }

    @Override
    public void dumpHeap() throws IOException {
        try {
            this.vm.dumpHeap();
        }
        catch (RemoteException e) {
            throw new IOException("RemoteException occurred", e);
        }
    }

    @Override
    public void dumpHeap(String info) throws IOException {
        try {
            this.vm.dumpHeap(info);
        }
        catch (RemoteException e) {
            throw new IOException("RemoteException occurred", e);
        }
    }

    @Override
    public synchronized String encode() {
        try {
            return this.vm.encode();
        }
        catch (RemoteException e) {
            Trace.get(this.getClass()).warn(e);
            return "RemoteException occurred";
        }
    }

    @Override
    public void exit(int exitCode) throws InvalidVmException {
        try {
            this.vm.exit(exitCode);
        }
        catch (RemoteException e) {
            throw new InvalidVmException(this, "RemoteException occurred", e);
        }
    }

    @Override
    public void forceGc() throws InvalidVmException {
        try {
            this.vm.forceGc();
        }
        catch (RemoteException e) {
            throw new InvalidVmException(this, "RemoteException occurred", e);
        }
    }

    @Override
    public void forceMaxGc() throws InvalidVmException {
        try {
            this.vm.forceMaxGc();
        }
        catch (RemoteException e) {
            throw new InvalidVmException(this, "RemoteException occurred", e);
        }
    }

    @Override
    public void dumpGcHistory() throws IOException {
        try {
            this.vm.dumpGcHistory();
        }
        catch (RemoteException e) {
            throw new IOException("RemoteException occurred", e);
        }
    }

    @Override
    public void dumpClassStatistic() throws IOException {
        try {
            this.vm.dumpClassStatistic();
        }
        catch (RemoteException e) {
            throw new IOException("RemoteException occurred", e);
        }
    }

    @Override
    public void dumpDetailedClassStatistic() throws IOException {
        try {
            this.vm.dumpDetailedClassStatistic();
        }
        catch (RemoteException e) {
            throw new IOException("RemoteException occurred", e);
        }
    }

    @Override
    public void dumpCodeblobs(String methodName, boolean showDetails) throws IOException {
        try {
            this.vm.dumpCodeblobs(methodName, showDetails);
        }
        catch (RemoteException e) {
            throw new IOException("RemoteException occurred", e);
        }
    }

    @Override
    public void dumpHsErrorInfo() throws IOException {
        try {
            this.vm.dumpHsErrorInfo();
        }
        catch (RemoteException e) {
            throw new IOException("RemoteException occurred", e);
        }
    }

    @Override
    public void dumpSymbolInfo() throws IOException {
        try {
            this.vm.dumpSymbolInfo();
        }
        catch (RemoteException e) {
            throw new IOException("RemoteException occurred", e);
        }
    }

    @Override
    public void dumpSafepointState() throws InvalidVmException {
        try {
            this.vm.dumpSafepointState();
        }
        catch (RemoteException e) {
            throw new InvalidVmException(this, "RemoteException occurred", e);
        }
    }

    @Override
    public void dumpDllInformation() throws IOException {
        try {
            this.vm.dumpDllInformation();
        }
        catch (RemoteException e) {
            throw new IOException("RemoteException occurred", e);
        }
    }

    @Override
    public VmDebugInfo getDebugInfo() throws InvalidVmException {
        try {
            return this.vm.getDebugInfo();
        }
        catch (RemoteException e) {
            throw new InvalidVmException(this, "RemoteException occurred", e);
        }
    }

    @Override
    public VmProfilingInfo getProfilingInfo() throws InvalidVmException {
        try {
            return this.vm.getProfilingInfo();
        }
        catch (RemoteException e) {
            throw new InvalidVmException(this, "RemoteException occurred", e);
        }
    }

    @Override
    public VmMemoryInfo getMemoryInfo() throws InvalidVmException {
        try {
            return this.vm.getMemoryInfo();
        }
        catch (RemoteException e) {
            throw new InvalidVmException(this, "RemoteException occurred", e);
        }
    }

    @Override
    public VmStateInfo getStateInfo() throws InvalidVmException {
        try {
            return this.vm.getStateInfo();
        }
        catch (RemoteException e) {
            throw new InvalidVmException(this, "RemoteException occurred", e);
        }
    }

    @Override
    public VmStartInfo getStartInfo() throws InvalidVmException {
        try {
            return this.vm.getStartInfo();
        }
        catch (RemoteException e) {
            throw new InvalidVmException(this, "RemoteException occurred", e);
        }
    }

    @Override
    public VmTimeInfo getTimeInfo() throws InvalidVmException {
        try {
            return this.vm.getTimeInfo();
        }
        catch (RemoteException e) {
            throw new InvalidVmException(this, "RemoteException occurred", e);
        }
    }

    @Override
    public VmTraceFlagsSet getTraceFlags() throws InvalidVmException {
        try {
            return this.vm.getTraceFlags();
        }
        catch (RemoteException e) {
            throw new InvalidVmException(this, "RemoteException occurred", e);
        }
    }

    @Override
    public int getVmIndex() {
        try {
            return this.vm.getVmIndex();
        }
        catch (RemoteException e) {
            Trace.get(this.getClass()).warn(e);
            return -1;
        }
    }

    @Override
    public VmSnapshot getVmSnapshot() throws InvalidVmException {
        try {
            return this.vm.getVmSnapshot();
        }
        catch (RemoteException e) {
            throw new InvalidVmException(this, "RemoteException occurred", e);
        }
    }

    @Override
    public boolean isValid() {
        try {
            return this.vm.isValid();
        }
        catch (RemoteException e) {
            Trace.get(this.getClass()).warn(e);
            return false;
        }
    }

    @Override
    public void printStackDump() throws IOException {
        try {
            this.vm.printStackDump();
        }
        catch (RemoteException e) {
            throw new IOException("RemoteException occurred", e);
        }
    }

    @Override
    public void printStackDump(String info) throws IOException {
        try {
            this.vm.printStackDump(info);
        }
        catch (RemoteException e) {
            throw new IOException("RemoteException occurred", e);
        }
    }

    @Override
    public void setDefaultDebugPortRange(PortRange range) throws InvalidVmException {
        try {
            this.vm.setDefaultDebugPortRange(range);
        }
        catch (RemoteException e) {
            throw new InvalidVmException(this, "RemoteException occurred", e);
        }
    }

    @Override
    public void setDefaultProfilingPortRange(PortRange range) throws InvalidVmException {
        try {
            this.vm.setDefaultProfilingPortRange(range);
        }
        catch (RemoteException e) {
            throw new InvalidVmException(this, "RemoteException occurred", e);
        }
    }

    @Override
    public void setTraceFlags(VmTraceFlagsSet traceFlags) throws InvalidVmException {
        try {
            this.vm.setTraceFlags(traceFlags);
        }
        catch (RemoteException e) {
            throw new InvalidVmException(this, "RemoteException occurred", e);
        }
    }

    @Override
    public void startDebug(SuspendPolicy suspendPolicy) throws InvalidVmException {
        try {
            this.vm.startDebug(suspendPolicy);
        }
        catch (RemoteException e) {
            throw new InvalidVmException(this, "RemoteException occurred", e);
        }
    }

    @Override
    public void startLocalDebug(SuspendPolicy suspendPolicy) throws InvalidVmException {
        try {
            this.vm.startLocalDebug(suspendPolicy);
        }
        catch (RemoteException e) {
            throw new InvalidVmException(this, "RemoteException occurred", e);
        }
    }

    @Override
    public void stopDebug() throws InvalidVmException {
        try {
            this.vm.stopDebug();
        }
        catch (RemoteException e) {
            throw new InvalidVmException(this, "RemoteException occurred", e);
        }
    }

    @Override
    public void startProfiling() throws InvalidVmException {
        try {
            this.vm.startProfiling();
        }
        catch (RemoteException e) {
            throw new InvalidVmException(this, "RemoteException occurred", e);
        }
    }

    @Override
    public void stopProfiling() throws InvalidVmException {
        try {
            this.vm.stopProfiling();
        }
        catch (RemoteException e) {
            throw new InvalidVmException(this, "RemoteException occurred", e);
        }
    }

    @Override
    public void startAttachServer() throws InvalidVmException {
        try {
            this.vm.startAttachServer();
        }
        catch (RemoteException e) {
            throw new InvalidVmException(this, "RemoteException occurred", e);
        }
    }

    @Override
    public boolean attachServerIsStarted() throws InvalidVmException {
        try {
            return this.vm.attachServerIsStarted();
        }
        catch (RemoteException e) {
            throw new InvalidVmException(this, "RemoteException occurred", e);
        }
    }

    public String toString() {
        return this.vm.toString();
    }

    @Override
    public ArrayList<String> getStackDump() throws IOException {
        try {
            return (ArrayList)this.vm.getStackDump();
        }
        catch (RemoteException e) {
            throw new IOException("RemoteException occurred", e);
        }
    }

    @Override
    public List<String> getClassStatistic() throws IOException {
        try {
            return this.vm.getClassStatistic();
        }
        catch (RemoteException e) {
            throw new IOException("RemoteException occurred", e);
        }
    }

    @Override
    public List<String> getDetailedClassStatistic() throws IOException {
        try {
            return this.vm.getDetailedClassStatistic();
        }
        catch (RemoteException e) {
            throw new IOException("RemoteException occurred", e);
        }
    }

    @Override
    public List<String> getCodeblobs(String methodName, boolean showDetails) throws IOException {
        try {
            return this.vm.getCodeblobs(methodName, showDetails);
        }
        catch (RemoteException e) {
            throw new IOException("RemoteException occurred", e);
        }
    }

    @Override
    public List<String> getDllInformation() throws IOException {
        try {
            return this.vm.getDllInformation();
        }
        catch (RemoteException e) {
            throw new IOException("RemoteException occurred", e);
        }
    }

    @Override
    public List<String> getHsErrorInfo() throws IOException {
        try {
            return this.vm.getHsErrorInfo();
        }
        catch (RemoteException e) {
            throw new IOException("RemoteException occurred", e);
        }
    }

    @Override
    public List<String> getSymbolInfo() throws IOException {
        try {
            return this.vm.getSymbolInfo();
        }
        catch (RemoteException e) {
            throw new IOException("RemoteException occurred", e);
        }
    }

    @Override
    public List<String> getSymbolInfo(int maxNumber) throws IOException {
        try {
            return this.vm.getSymbolInfo(maxNumber);
        }
        catch (RemoteException e) {
            throw new IOException("RemoteException occurred", e);
        }
    }

    @Override
    public List<String> getGcHistory() throws IOException {
        try {
            return this.vm.getGcHistory();
        }
        catch (RemoteException e) {
            throw new IOException("RemoteException occurred", e);
        }
    }

    @Override
    public List<String> getFlightrecorder(int numLastEntries) throws IOException {
        try {
            return this.vm.getFlightrecorder(numLastEntries);
        }
        catch (RemoteException e) {
            throw new IOException("RemoteException occurred", e);
        }
    }

    @Override
    public boolean supportsOperation(MonitorOperation op) throws InvalidVmException {
        try {
            return this.vm.supportsOperation(op);
        }
        catch (RemoteException e) {
            throw new InvalidVmException(this, "RemoteException occurred", e);
        }
    }

    @Override
    public List<String> performOperation(MonitorOperation op, String ... args) throws IOException {
        try {
            return this.vm.performOperation(op, args);
        }
        catch (RemoteException e) {
            throw new IOException("RemoteException occurred", e);
        }
    }

    @Override
    public byte[] retrieveCompleteGcHistory() throws InvalidVmException {
        try {
            return this.vm.retrieveCompleteGcHistory();
        }
        catch (RemoteException e) {
            throw new InvalidVmException(this, "RemoteException occurred", e);
        }
    }
}

