/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.monitor.statistic.allocation;

import com.sap.jvm.impl.extensions.WithExtensionsNativeLib;
import com.sap.jvm.monitor.MonitoringPermission;
import com.sap.jvm.monitor.statistic.allocation.AllocationStatistic;
import java.util.HashMap;
import java.util.Map;

public final class AllocationStatisticTraceImpl
extends WithExtensionsNativeLib {
    private static Map<Short, AllocationStatistic> convert(long[] rawStatistics) {
        HashMap<Short, AllocationStatistic> statistics = new HashMap<Short, AllocationStatistic>();
        for (int i = 0; i < rawStatistics.length; i += 4) {
            if (rawStatistics[i] <= 0L) continue;
            AllocationStatistic statistic = new AllocationStatistic(rawStatistics[i], rawStatistics[i + 1], rawStatistics[i + 2], rawStatistics[i + 3]);
            statistics.put((short)(i / 4), statistic);
        }
        return statistics;
    }

    public static boolean start() {
        MonitoringPermission.checkPermission(MonitoringPermission.EXECUTE_PERMISSION);
        return AllocationStatisticTraceImpl.start0();
    }

    public static Map<Short, AllocationStatistic> get() {
        long[] rawStatistics = AllocationStatisticTraceImpl.getRaw();
        return rawStatistics == null ? null : AllocationStatisticTraceImpl.convert(rawStatistics);
    }

    public static long[] getRaw() {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        return AllocationStatisticTraceImpl.get0();
    }

    public static Map<Short, AllocationStatistic> getWithoutGC() {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        long[] rawStatistics = AllocationStatisticTraceImpl.getWithoutGC0();
        return rawStatistics == null ? null : AllocationStatisticTraceImpl.convert(rawStatistics);
    }

    public static short[] getTagsForObjects(Object[] objects) {
        MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
        if (objects == null) {
            return null;
        }
        short[] tags = new short[objects.length];
        return (short[])(AllocationStatisticTraceImpl.getTagsForObjects0(objects, tags) ? tags : null);
    }

    public static Map<Short, AllocationStatistic> stop() {
        long[] rawStatistics = AllocationStatisticTraceImpl.stopRaw();
        return rawStatistics == null ? null : AllocationStatisticTraceImpl.convert(rawStatistics);
    }

    public static long[] stopRaw() {
        MonitoringPermission.checkPermission(MonitoringPermission.EXECUTE_PERMISSION);
        return AllocationStatisticTraceImpl.stop0();
    }

    private static native boolean start0();

    private static native long[] get0();

    private static native long[] getWithoutGC0();

    private static native boolean getTagsForObjects0(Object[] var0, short[] var1);

    private static native long[] stop0();
}

