/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.monitor.thread;

import com.sap.jvm.impl.monitor.thread.DeadlockedThreadImpl;
import com.sap.jvm.monitor.thread.Deadlock;
import com.sap.jvm.monitor.thread.DeadlockedThread;
import java.io.DataInputStream;
import java.io.IOException;

public class DeadlockImpl
implements Deadlock {
    private static long globalDetectionCounter = 0L;
    private final DeadlockedThread[] threads;
    private final DeadlockedThread[] waitingThreads;
    private long detectionCount;

    private DeadlockImpl(DataInputStream stream, long nrOfDetection) throws IOException {
        this.threads = DeadlockedThreadImpl.readThreads(stream);
        this.waitingThreads = DeadlockedThreadImpl.readThreads(stream);
        this.detectionCount = nrOfDetection;
    }

    @Override
    public DeadlockedThread[] getThreads() {
        return this.threads;
    }

    @Override
    public DeadlockedThread[] getWaitingThreads() {
        return this.waitingThreads;
    }

    public static DeadlockImpl[] readDeadlocks(DataInputStream stream) throws IOException {
        int nrOfDeadlocks = stream.readInt();
        DeadlockImpl[] result = new DeadlockImpl[nrOfDeadlocks];
        long detectionCount = ++globalDetectionCounter;
        for (int i = 0; i < nrOfDeadlocks; ++i) {
            result[i] = new DeadlockImpl(stream, detectionCount);
        }
        return result;
    }
}

