/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.monitor.thread;

import com.sap.jvm.impl.monitor.thread.NativeThreadWatcherCallback;
import com.sap.jvm.impl.monitor.thread.NativeThreadWatcherImpl;
import com.sap.jvm.monitor.MonitoringPermission;
import com.sap.jvm.monitor.thread.ThreadWatcher;
import java.lang.reflect.Field;

public final class ThreadWatcherImpl
extends ThreadWatcher {
    private static ThreadWatcherImpl theInstance;
    private NativeThreadWatcherImpl nativeImpl;
    private Field targetField;

    private ThreadWatcherImpl() throws UnsupportedOperationException, SecurityException {
        try {
            this.targetField = Thread.class.getDeclaredField("target");
        }
        catch (NoSuchFieldException e) {
            throw new UnsupportedOperationException("This VM does not support thread watching", e);
        }
        this.targetField.setAccessible(true);
        this.nativeImpl = NativeThreadWatcherImpl.getInstance();
    }

    public static synchronized ThreadWatcher getInstance() throws UnsupportedOperationException, SecurityException {
        MonitoringPermission.checkPermission(MonitoringPermission.EXECUTE_PERMISSION);
        if (theInstance == null) {
            theInstance = new ThreadWatcherImpl();
        }
        return theInstance;
    }

    @Override
    public void registerCallback(ThreadWatcher.Callback callback) {
        CallbackAdapter callbackAdapter = callback == null ? null : new CallbackAdapter(callback);
        this.nativeImpl.registerCallback(callbackAdapter);
    }

    class CallbackAdapter
    implements NativeThreadWatcherCallback {
        private ThreadWatcher.Callback callback;

        CallbackAdapter(ThreadWatcher.Callback callback) {
            this.callback = callback;
        }

        @Override
        public void ended() {
            this.callback.ended();
        }

        @Override
        public void started() {
            Thread thread = Thread.currentThread();
            try {
                Runnable runnable = (Runnable)ThreadWatcherImpl.this.targetField.get(thread);
                if (runnable == null) {
                    runnable = thread;
                }
                this.callback.started(runnable);
            }
            catch (IllegalAccessException e) {
                throw new InternalError("Unexpected IllegalAccessException accessing thread target");
            }
        }
    }
}

