/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.monitor.transport;

import com.sap.jvm.impl.monitor.transport.JvmmondSocket;
import com.sap.jvm.impl.monitor.transport.JvmmondSocketTools;
import com.sap.jvm.monitor.vm.PortRange;
import com.sap.jvm.tracing.Trace;
import com.sap.jvm.tracing.Tracer;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.server.RMIServerSocketFactory;
import java.util.concurrent.Semaphore;

public class JvmmondServerSocketFactory
implements RMIServerSocketFactory {
    private final PortRange portRange;
    private int lastPort = -1;
    private final String password;
    private final boolean enforceLocal;
    private final boolean usePlainSocket;
    private final NewProtocolHandlerStarter nphs;
    private static final int authenticationRequestThrottleMs = 100;
    private static final Semaphore authenticationRequestSemaphore = new Semaphore(10);

    public JvmmondServerSocketFactory(String password, boolean enforceLocal, NewProtocolHandlerStarter nphs, PortRange portRange) {
        if (password != null && nphs != null) {
            throw new IllegalArgumentException("Socket password authentication and new protocol handshaking not allowed in one server socket.");
        }
        this.password = password;
        this.enforceLocal = enforceLocal;
        this.nphs = nphs;
        this.portRange = portRange;
        this.usePlainSocket = password == null && !enforceLocal && nphs == null;
    }

    public int getLastPort() {
        return this.lastPort;
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        if (this.portRange != null) {
            Tracer trc = Trace.get(this.getClass());
            if (port > 0) {
                trc.debug(() -> "Trying to open server on port " + port + "...");
                ServerSocket resultServer = this.usePlainSocket ? new ServerSocket(port) : new JvmmondServerSocket(port);
                this.lastPort = port;
                return resultServer;
            }
            IOException lastException = null;
            for (int testPort = this.portRange.getFromPort(); testPort <= this.portRange.getToPort(); ++testPort) {
                try {
                    int currPort = testPort;
                    trc.debug(() -> "Trying to open server on port " + currPort + "...");
                    ServerSocket resultServer = this.usePlainSocket ? new ServerSocket(testPort) : new JvmmondServerSocket(testPort);
                    this.lastPort = testPort;
                    return resultServer;
                }
                catch (IOException e) {
                    trc.debug(() -> "Not successful: " + e.getMessage() + ".");
                    lastException = e;
                    continue;
                }
            }
            trc.error(() -> "Port range seems to be exhausted.");
            throw lastException;
        }
        Trace.get(this.getClass()).debug(() -> "Opening server socket on port " + port + "...");
        return this.usePlainSocket ? new ServerSocket(port) : new JvmmondServerSocket(port);
    }

    public int hashCode() {
        return this.password == null ? super.hashCode() : this.password.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JvmmondServerSocketFactory jsf = (JvmmondServerSocketFactory)obj;
        return this.enforceLocal == jsf.enforceLocal && (this.password == null && jsf.password == null || this.password.equals(jsf.password));
    }

    public class JvmmondServerSocket
    extends ServerSocket {
        public JvmmondServerSocket(int port) throws IOException {
            super(port);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Socket accept() throws IOException {
            JvmmondSocket s;
            if (JvmmondServerSocketFactory.this.usePlainSocket) {
                return super.accept();
            }
            while (true) {
                s = new JvmmondSocket(JvmmondServerSocketFactory.this.password, JvmmondServerSocketFactory.this.nphs != null);
                this.implAccept(s);
                if (JvmmondServerSocketFactory.this.enforceLocal && !JvmmondSocketTools.isLocalAddress(s.getInetAddress())) {
                    s.close();
                    String message = "blocked extern connection request.";
                    Trace.get(this.getClass()).debug(message);
                    throw new IOException(message);
                }
                if (JvmmondServerSocketFactory.this.password != null) {
                    boolean authenticationSuccess = false;
                    try {
                        authenticationRequestSemaphore.acquire();
                        Thread.sleep(100L);
                        authenticationSuccess = s.authenticationRequest();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    finally {
                        authenticationRequestSemaphore.release();
                    }
                    if (!authenticationSuccess) {
                        s.close();
                        String message = "blocked connection request with wrong password.";
                        Trace.get(this.getClass()).debug(message);
                        throw new IOException(message);
                    }
                }
                if (JvmmondServerSocketFactory.this.nphs == null || !JvmmondSocketTools.newProtocolHandshake(s)) break;
                JvmmondServerSocketFactory.this.nphs.start(s);
            }
            return s;
        }
    }

    public static interface NewProtocolHandlerStarter {
        public void start(Socket var1) throws IOException;
    }
}

