/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.monitor.transport;

import com.sap.jvm.impl.monitor.transport.JvmmondSocketTools;
import com.sap.jvm.tracing.Trace;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public class JvmmondSocket
extends Socket {
    private static final byte authenticationVersion = 1;
    private final byte[] xorPattern;
    private boolean returnBufferedInputStream = false;
    private BufferedInputStream bis = null;

    private static byte[] xor(byte[] message, byte[] xorBytes) {
        byte[] result = new byte[message.length];
        for (int i = 0; i < message.length; ++i) {
            result[i] = (byte)((message[i] ^ xorBytes[i % xorBytes.length]) & 0xFF);
        }
        return result;
    }

    private static byte[] getHash(byte[] input) {
        try {
            return MessageDigest.getInstance("MD5").digest(input);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return input;
        }
    }

    private static byte[] xorPatternFromStringToken(String token) {
        if (token == null) {
            return null;
        }
        byte[] xorPattern = new byte[2 * token.length()];
        for (int i = 0; i < token.length(); ++i) {
            char curChar = token.charAt(i);
            xorPattern[2 * i] = (byte)(curChar >> 8 & 0xFF);
            xorPattern[2 * i + 1] = (byte)(curChar & 0xFF);
        }
        return JvmmondSocket.getHash(xorPattern);
    }

    public JvmmondSocket(String password, boolean returnBufferedInputStream) throws IOException {
        this.xorPattern = JvmmondSocket.xorPatternFromStringToken(password);
        this.returnBufferedInputStream = returnBufferedInputStream;
    }

    public JvmmondSocket(String host, int port, String password) throws IOException {
        super(host, port);
        this.xorPattern = JvmmondSocket.xorPatternFromStringToken(password);
        Trace.get(this.getClass()).debug(() -> "Connecting a socket to " + host + ":" + port + ", password set:" + (password != null) + ".");
        if (this.isConnected() && this.xorPattern != null) {
            try {
                this.authenticationResponse();
            }
            catch (IOException e) {
                super.close();
                throw e;
            }
        }
    }

    public boolean authenticationRequest() {
        try {
            DataOutputStream ds = new DataOutputStream(this.getOutputStream());
            ds.write(1);
            byte[] challenge = new byte[128];
            new SecureRandom().nextBytes(challenge);
            byte[] xorChallenge = JvmmondSocket.xor(challenge, this.xorPattern);
            ds.write(xorChallenge.length & 0xFF);
            ds.write(xorChallenge);
            DataInputStream dis = new DataInputStream(this.getInputStream());
            int length = dis.read() & 0xFF;
            byte[] xoredHashedChallenge = new byte[length];
            dis.readFully(xoredHashedChallenge);
            byte[] hashedChallenge = JvmmondSocket.xor(xoredHashedChallenge, this.xorPattern);
            byte[] testHash = JvmmondSocket.getHash(challenge);
            if (testHash.length != hashedChallenge.length) {
                return false;
            }
            for (int i = 0; i < testHash.length && i < hashedChallenge.length; ++i) {
                if (hashedChallenge[i] == testHash[i]) continue;
                return false;
            }
            return true;
        }
        catch (IOException e) {
            Trace.get(JvmmondSocketTools.class).error((Throwable)e, () -> "Caught IOException during socket authentication: " + e.getMessage());
            return false;
        }
    }

    public void authenticationResponse() throws IOException {
        DataInputStream ds = new DataInputStream(this.getInputStream());
        int version = ds.read() & 0xFF;
        if (version > 1) {
            throw new IOException("Can't connect to new xor server: authentication protocol unknown");
        }
        int len = ds.read() & 0xFF;
        byte[] xoredChallenge = new byte[len];
        ds.readFully(xoredChallenge);
        byte[] challenge = JvmmondSocket.xor(xoredChallenge, this.xorPattern);
        DataOutputStream dos = new DataOutputStream(this.getOutputStream());
        byte[] hashedChallenge = JvmmondSocket.xor(JvmmondSocket.getHash(challenge), this.xorPattern);
        dos.write(hashedChallenge.length);
        dos.write(hashedChallenge);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getInputStream() throws IOException {
        if (!this.returnBufferedInputStream) {
            return super.getInputStream();
        }
        if (this.bis == null) {
            JvmmondSocket jvmmondSocket = this;
            synchronized (jvmmondSocket) {
                if (this.bis == null) {
                    this.bis = new BufferedInputStream(super.getInputStream());
                }
            }
        }
        return this.bis;
    }
}

