/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.monitor.transport;

import com.sap.jvm.tracing.Trace;
import com.sap.jvm.tracing.Tracer;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;

public class JvmmondSocketTools {
    public static final char[] HANDSHAKE = new char[]{'s', 'a', 'p', 'j', 'v', 'm', 'm', 'o', 'n', 'd', 't', 'e', 's', 't'};
    private static Map<String, String> tokenMap = new HashMap<String, String>();

    static boolean isLocalAddress(InetAddress addr) {
        try {
            new ServerSocket(0, 10, addr).close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean newProtocolHandshake(Socket s) {
        InputStream is;
        Tracer trc = Trace.get(JvmmondSocketTools.class);
        try {
            is = s.getInputStream();
        }
        catch (IOException e) {
            trc.error((Throwable)e, "Could not get InputStream for new protocol handshake.");
            return false;
        }
        boolean doReset = false;
        if (is instanceof BufferedInputStream) {
            trc.debug("Returned InputStream is an instance of BufferedInputStream.");
            ((BufferedInputStream)is).mark(HANDSHAKE.length);
            doReset = true;
        } else {
            trc.debug("Returned InputStream is not an instance of BufferedInputStream.");
        }
        try {
            for (int i = 0; i < HANDSHAKE.length; ++i) {
                try {
                    if (is.read() == HANDSHAKE[i]) continue;
                    trc.debug("Handshake for new protocol unsuccessful.");
                    boolean bl = false;
                    return bl;
                }
                catch (IOException e) {
                    int currI = i;
                    trc.debug((Throwable)e, () -> "Caught IOException reading " + currI + ". byte of handshake.");
                    boolean bl = false;
                    return bl;
                }
            }
            try {
                OutputStream os = s.getOutputStream();
                for (int i = 0; i < HANDSHAKE.length; ++i) {
                    os.write(HANDSHAKE[i]);
                }
            }
            catch (IOException e) {
                trc.warn((Throwable)e, "Caught IOException writing handshake.");
                boolean i = false;
                if (doReset) {
                    try {
                        ((BufferedInputStream)is).reset();
                    }
                    catch (IOException e2) {
                        trc.warn((Throwable)e2, "Caught IOException resetting stream after unsuccessful handshake.");
                    }
                }
                return i;
            }
            doReset = false;
            trc.debug("Handshake for new protocol successful.");
            boolean bl = true;
            return bl;
        }
        finally {
            if (doReset) {
                try {
                    ((BufferedInputStream)is).reset();
                }
                catch (IOException e) {
                    trc.warn((Throwable)e, "Caught IOException resetting stream after unsuccessful handshake.");
                }
            }
        }
    }

    public static final String getPasswordFromHexRepresentation(String hexRep) throws IllegalArgumentException {
        if (hexRep.length() % 4 != 0) {
            throw new IllegalArgumentException("HexString must have even length.");
        }
        char[] passwordChars = new char[hexRep.length() / 4];
        for (int i = 0; i < passwordChars.length; ++i) {
            String hex = hexRep.substring(4 * i, 4 * i + 4);
            passwordChars[i] = (char)Integer.parseInt(hex, 16);
        }
        return new String(passwordChars);
    }

    public static void registerPassword(String token, String host, int port) {
        try {
            InetAddress[] addrs = InetAddress.getAllByName(host);
            for (int i = 0; i < addrs.length; ++i) {
                String ipAddress = addrs[i].getHostAddress();
                tokenMap.put(ipAddress + ":" + port, token);
            }
            if (JvmmondSocketTools.isLocalAddress(InetAddress.getByName(host))) {
                String ipAddress = InetAddress.getLocalHost().getHostAddress();
                tokenMap.put(ipAddress + ":" + port, token);
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public static String lookupPasswordToken(String host, int port) {
        String token = null;
        try {
            InetAddress[] addrs = InetAddress.getAllByName(host);
            for (int i = 0; i < addrs.length && token == null; ++i) {
                String ipAddress = addrs[i].getHostAddress();
                token = tokenMap.get(ipAddress + ":" + port);
            }
            if (token == null && JvmmondSocketTools.isLocalAddress(InetAddress.getByName(host))) {
                String ipAddress = InetAddress.getLocalHost().getHostAddress();
                token = tokenMap.get(ipAddress + ":" + port);
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return token;
    }
}

