/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.monitor.vm;

import com.sap.jvm.monitor.vm.DebugState;
import com.sap.jvm.monitor.vm.PortRange;
import com.sap.jvm.monitor.vm.VmDebugInfo;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;

public final class VmDebugInfoImpl
implements VmDebugInfo,
Serializable {
    private static final long serialVersionUID = -1898688325412996751L;
    private final boolean debugOnDemand;
    private final PortRange defaultPortRange;
    private final DebugState debugState;
    private final int debugPort;
    private final String debugClient;
    private final boolean isLocalOnly;

    public VmDebugInfoImpl(DataInputStream stream) throws IOException {
        this.debugOnDemand = stream.readBoolean();
        int fromPort = stream.readInt();
        int toPort = stream.readInt();
        if (fromPort == -1) {
            assert (fromPort == toPort);
            this.defaultPortRange = PortRange.UNDEFINED_PORT_RANGE;
        } else {
            this.defaultPortRange = new PortRange(fromPort, toPort);
        }
        this.debugState = this.convertIndexToDebugState(stream.readInt());
        this.debugPort = stream.readInt();
        this.debugClient = stream.readUTF();
        this.isLocalOnly = stream.available() >= 1 ? stream.readBoolean() : false;
    }

    private DebugState convertIndexToDebugState(int index) {
        switch (index) {
            case 0: {
                return DebugState.STATE_UNKNOWN;
            }
            case 1: {
                return DebugState.STATE_NOT_ACTIVE;
            }
            case 2: {
                return DebugState.STATE_REQUESTED;
            }
            case 3: {
                return DebugState.STATE_STARTING;
            }
            case 4: {
                return DebugState.STATE_WAIT_FOR_DEBUGGER;
            }
            case 5: {
                return DebugState.STATE_DEBUGGER_ATTACHED;
            }
            case 6: {
                return DebugState.STATE_STOPPING;
            }
        }
        return null;
    }

    @Override
    public boolean isDebugOnDemandSupported() {
        return this.debugOnDemand;
    }

    @Override
    public PortRange getDefaultDebugPortRange() {
        return this.defaultPortRange;
    }

    @Override
    public DebugState getDebugState() {
        return this.debugState;
    }

    @Override
    public int getDebugPort() {
        return this.debugPort;
    }

    @Override
    public String getDebugClient() {
        return this.debugClient;
    }

    @Override
    public boolean isLocalOnly() {
        return this.isLocalOnly;
    }
}

