/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.monitor.vm;

import com.sap.jvm.monitor.vm.VmMemoryInfo;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;

public final class VmMemoryInfoImpl
implements VmMemoryInfo,
Serializable {
    private static final long serialVersionUID = -5436980655859995186L;
    private final long memoryConsumption;
    private final long memoryAllocation;
    private final long javaHeapMemoryConsumption;
    private final long javaHeapMemoryAllocation;
    private final long classMemoryConsumption;
    private final long classMemoryAllocation;
    private final long codeMemoryConsumption;
    private final long codeMemoryAllocation;
    private final long miscMemoryConsumption = 0L;
    private final long miscMemoryAllocation = 0L;
    private final long sharedPoolSize;
    private final long sharedMemoryConsumption;
    private final long sharedMemoryAllocation;
    private final long sharedClassMemoryConsumption = 0L;
    private final long sharedClassMemoryAllocation = 0L;
    private final long sharedClassPeakMemoryConsumption = 0L;
    private final long sharedCodeMemoryConsumption = 0L;
    private final long sharedCodeMemoryAllocation = 0L;
    private final long sharedCodePeakMemoryConsumption = 0L;
    private final long sharedDataMemoryConsumption;
    private final long sharedDataMemoryAllocation;
    private final long sharedDataPeakMemoryConsumption;
    private final long sharedMiscMemoryConsumption = 0L;
    private final long sharedMiscMemoryAllocation = 0L;
    private final long sharedMiscPeakMemoryConsumption = 0L;
    private final long gcNr;
    private final long fullGcNr;
    private final long gcDuration;
    private final long fullGcDuration;
    private final long concurrentGcDuration;
    private final long gcWorkTime;
    private final long fullGcWorkTime;
    private final int gcSpinningDueToJavaHeap;
    private final int gcSpinningDueToPermGen;
    private final int javaHeapMemoryShortages;
    private final int permGenMemoryShortages;
    private final int outOfMemoryErrorCount;
    private final long oldGenMemoryConsumptionAfterGc;
    private final long permGenMemoryConsumptionAfterGc;
    private final long maxOldGenMemorySize;
    private final long maxPermGenMemorySize;

    public VmMemoryInfoImpl(DataInputStream stream) throws IOException {
        this.memoryConsumption = stream.readLong();
        this.javaHeapMemoryConsumption = stream.readLong();
        this.classMemoryConsumption = stream.readLong();
        this.codeMemoryConsumption = stream.readLong();
        this.memoryAllocation = stream.readLong();
        this.javaHeapMemoryAllocation = stream.readLong();
        this.classMemoryAllocation = stream.readLong();
        this.codeMemoryAllocation = stream.readLong();
        this.sharedPoolSize = stream.readLong();
        this.sharedDataMemoryConsumption = this.sharedMemoryConsumption = stream.readLong();
        this.sharedDataMemoryAllocation = this.sharedMemoryAllocation = stream.readLong();
        this.sharedDataPeakMemoryConsumption = stream.readLong();
        this.gcNr = stream.readLong();
        this.fullGcNr = stream.readLong();
        this.gcDuration = stream.readLong();
        this.fullGcDuration = stream.readLong();
        this.concurrentGcDuration = stream.readLong();
        this.gcWorkTime = stream.readLong();
        this.fullGcWorkTime = stream.readLong();
        this.javaHeapMemoryShortages = stream.readInt();
        this.permGenMemoryShortages = stream.readInt();
        this.gcSpinningDueToJavaHeap = stream.readInt();
        this.gcSpinningDueToPermGen = stream.readInt();
        this.outOfMemoryErrorCount = stream.readInt();
        this.oldGenMemoryConsumptionAfterGc = stream.readLong();
        this.permGenMemoryConsumptionAfterGc = stream.readLong();
        this.maxOldGenMemorySize = stream.readLong();
        this.maxPermGenMemorySize = stream.readLong();
    }

    @Override
    public long getMemoryConsumption() {
        return this.memoryConsumption;
    }

    @Override
    public long getMemoryAllocation() {
        return this.memoryAllocation;
    }

    @Override
    public long getJavaHeapMemoryConsumption() {
        return this.javaHeapMemoryConsumption;
    }

    @Override
    public long getJavaHeapMemoryAllocation() {
        return this.javaHeapMemoryAllocation;
    }

    @Override
    public long getClassesMemoryConsumption() {
        return this.classMemoryConsumption;
    }

    @Override
    public long getClassesMemoryAllocation() {
        return this.classMemoryAllocation;
    }

    @Override
    public long getCodeMemoryConsumption() {
        return this.codeMemoryConsumption;
    }

    @Override
    public long getCodeMemoryAllocation() {
        return this.codeMemoryAllocation;
    }

    @Override
    public long getMiscMemoryConsumption() {
        return 0L;
    }

    @Override
    public long getMiscMemoryAllocation() {
        return 0L;
    }

    @Override
    public long getSharedPoolSize() {
        return this.sharedPoolSize;
    }

    @Override
    public long getSharedMemoryConsumption() {
        return this.sharedMemoryConsumption;
    }

    @Override
    public long getSharedMemoryAllocation() {
        return this.sharedMemoryAllocation;
    }

    @Override
    public long getSharedClassesMemoryConsumption() {
        return 0L;
    }

    @Override
    public long getSharedClassesMemoryAllocation() {
        return 0L;
    }

    @Override
    public long getSharedClassesPeakMemoryConsumption() {
        return 0L;
    }

    @Override
    public long getSharedCodeMemoryConsumption() {
        return 0L;
    }

    @Override
    public long getSharedCodeMemoryAllocation() {
        return 0L;
    }

    @Override
    public long getSharedCodePeakMemoryConsumption() {
        return 0L;
    }

    @Override
    public long getSharedDataMemoryConsumption() {
        return this.sharedDataMemoryConsumption;
    }

    @Override
    public long getSharedDataMemoryAllocation() {
        return this.sharedDataMemoryAllocation;
    }

    @Override
    public long getSharedDataPeakMemoryConsumption() {
        return this.sharedDataPeakMemoryConsumption;
    }

    @Override
    public long getSharedMiscMemoryConsumption() {
        return 0L;
    }

    @Override
    public long getSharedMiscMemoryAllocation() {
        return 0L;
    }

    @Override
    public long getSharedMiscPeakMemoryConsumption() {
        return 0L;
    }

    @Override
    public long getOldGenFilled50Counter() {
        return 0L;
    }

    @Override
    public long getOldGenFilled75Counter() {
        return 0L;
    }

    @Override
    public long getOldGenFilled90Counter() {
        return 0L;
    }

    @Override
    public long getGcCpuTime() {
        return 0L;
    }

    @Override
    public long getGcPageFaults() {
        return 0L;
    }

    @Override
    public long getGcNr() {
        return this.gcNr;
    }

    @Override
    public long getFullGcNr() {
        return this.fullGcNr;
    }

    @Override
    public long getGcDuration() {
        return this.gcDuration;
    }

    @Override
    public long getFullGcDuration() {
        return this.fullGcDuration;
    }

    @Override
    public long getConcurrentGcDuration() {
        return this.concurrentGcDuration;
    }

    @Override
    public long getGcWorkTime() {
        return this.gcWorkTime;
    }

    @Override
    public long getFullGcWorkTime() {
        return this.fullGcWorkTime;
    }

    @Override
    public int getGcSpinningDueToJavaHeap() {
        return this.gcSpinningDueToJavaHeap;
    }

    @Override
    public int getGcSpinningDueToPermGen() {
        return this.gcSpinningDueToPermGen;
    }

    @Override
    public int getJavaHeapMemoryShortages() {
        return this.javaHeapMemoryShortages;
    }

    @Override
    public int getPermGenMemoryShortages() {
        return this.permGenMemoryShortages;
    }

    @Override
    public int getOutOfMemoryErrorCount() {
        return this.outOfMemoryErrorCount;
    }

    @Override
    public long getOldGenMemoryConsumptionAfterGc() {
        return this.oldGenMemoryConsumptionAfterGc;
    }

    @Override
    public long getPermGenMemoryConsumptionAfterGc() {
        return this.permGenMemoryConsumptionAfterGc;
    }

    @Override
    public long getMaxOldGenMemorySize() {
        return this.maxOldGenMemorySize;
    }

    @Override
    public long getMaxPermGenMemorySize() {
        return this.maxPermGenMemorySize;
    }
}

