/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.monitor.vm;

import com.sap.jvm.monitor.vm.VmStartInfo;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class VmStartInfoImpl
implements VmStartInfo,
Serializable {
    private static final long serialVersionUID = -431014019137855987L;
    private final String vmVersion;
    private final String workingDir;
    private final String[] vmFlags;
    private final String[] vmArgs;
    private final String javaArgs;
    private final String vmTag;
    private final String mainClass;
    private final String[] javaArgsArray;
    private final String jarFilename;
    private final boolean runWithMonitoringBoard;
    private final boolean hasMetaspace;

    public VmStartInfoImpl(DataInputStream stream) throws IOException {
        StringTokenizer st;
        this.vmVersion = stream.readUTF();
        this.workingDir = stream.readUTF();
        String tmpVmFlags = stream.readUTF();
        String tmpVmArgs = stream.readUTF();
        this.javaArgs = stream.readUTF();
        this.vmTag = stream.readUTF();
        String splittableArgs = stream.readUTF();
        String jarMainClass = stream.readUTF();
        this.runWithMonitoringBoard = stream.readBoolean();
        this.hasMetaspace = stream.readBoolean();
        ArrayList<String> ar = new ArrayList<String>();
        if (tmpVmFlags != null) {
            st = new StringTokenizer(tmpVmFlags, "\u0001");
            while (st.hasMoreTokens()) {
                ar.add(st.nextToken());
            }
        }
        this.vmFlags = ar.toArray(new String[ar.size()]);
        ar.clear();
        if (tmpVmArgs != null) {
            st = new StringTokenizer(tmpVmArgs, "\u0001");
            while (st.hasMoreTokens()) {
                ar.add(st.nextToken());
            }
        }
        this.vmArgs = ar.toArray(new String[ar.size()]);
        String toSplit = splittableArgs;
        String splitChar = "\u0001";
        if (splittableArgs.length() == 0) {
            toSplit = this.javaArgs;
            splitChar = " ";
        }
        if (toSplit.length() == 0) {
            this.mainClass = null;
            this.javaArgsArray = new String[0];
            this.jarFilename = null;
            return;
        }
        StringTokenizer st2 = new StringTokenizer(toSplit, splitChar);
        ar.clear();
        while (st2.hasMoreTokens()) {
            ar.add(st2.nextToken());
        }
        if (jarMainClass.length() > 0) {
            this.mainClass = jarMainClass;
            this.jarFilename = (String)ar.get(0);
        } else {
            this.mainClass = (String)ar.get(0);
            this.jarFilename = null;
        }
        this.javaArgsArray = new String[ar.size() - 1];
        for (int i = 1; i < ar.size(); ++i) {
            this.javaArgsArray[i - 1] = (String)ar.get(i);
        }
    }

    @Override
    public String getVmVersion() {
        return this.vmVersion;
    }

    @Override
    public String getWorkingDirectory() {
        return this.workingDir;
    }

    @Override
    @Deprecated
    public String[] getVmFlags() {
        return this.vmFlags;
    }

    @Override
    public String[] getVmArguments() {
        return this.vmArgs;
    }

    @Override
    public String getJavaArguments() {
        if (this.mainClass == null) {
            return this.javaArgs;
        }
        String result = this.mainClass;
        for (String arg : this.javaArgsArray) {
            result = result + " " + arg;
        }
        return result;
    }

    @Override
    public String getVmTag() {
        return this.vmTag;
    }

    @Override
    public String[] getJavaArgumentsAsArray() {
        return this.javaArgsArray;
    }

    @Override
    public String getMainClass() {
        return this.mainClass;
    }

    @Override
    public String getJarFilename() {
        return this.jarFilename;
    }

    @Override
    public boolean isRunningWithAMonitoringBoard() {
        return this.runWithMonitoringBoard;
    }

    @Override
    public boolean hasMetaspace() {
        return this.hasMetaspace;
    }
}

