/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.monitor.vm;

import com.sap.jvm.monitor.vm.VmStateInfo;
import com.sap.jvm.monitor.vm.VmTraceFlag;
import com.sap.jvm.monitor.vm.VmTraceFlagsSet;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;

public class VmStateInfoImpl
implements VmStateInfo,
Serializable {
    private static final long serialVersionUID = 2574548558160153553L;
    private final int vmIndex;
    private final int pid;
    private final VmTraceFlagsSet traceFlags = new VmTraceFlagsSet();

    public VmStateInfoImpl(DataInputStream stream) throws IOException {
        int index;
        this.vmIndex = stream.readInt();
        this.pid = stream.readInt();
        while ((index = stream.readInt()) != -1) {
            this.traceFlags.setFlag(VmTraceFlag.getFlagByNumber(index));
        }
    }

    @Override
    public int getVmIndex() {
        return this.vmIndex;
    }

    @Override
    public VmTraceFlagsSet getTraceFlags() {
        return this.traceFlags;
    }

    @Override
    public int getPid() {
        return this.pid;
    }
}

