/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.profiling.vm;

import com.sap.jvm.extension.java.base.ProfilingControl;
import java.io.IOException;
import java.io.OutputStream;

public class OutputStreamImpl
extends OutputStream {
    private static final int MAPPING_BUFFER_SIZE = 0x500000;
    private static final int EVENT_BUFFER_SIZE = 0x500000;
    private static final int COMMAND_BUFFER_SIZE = 10240;
    private ProfilingControl profilingControl;
    private byte[] data;
    private int offset;

    OutputStreamImpl(String filePrefix) {
        this.profilingControl = new ProfilingControl(filePrefix, 0x500000, 0x500000);
        this.data = new byte[10240];
        this.offset = 0;
    }

    @Override
    public void write(int b) {
        if (this.offset >= this.data.length) {
            byte[] oldData = this.data;
            this.data = new byte[2 * this.data.length];
            System.arraycopy(oldData, 0, this.data, 0, oldData.length);
        }
        this.data[this.offset++] = (byte)b;
    }

    @Override
    public synchronized void flush() throws IOException {
        if (!this.profilingControl.isValid()) {
            throw new IOException("Profiling run has been deleted meanwhile.");
        }
        this.profilingControl.sendCommand(this.data, 0, this.offset);
        this.offset = 0;
    }

    @Override
    public synchronized void close() {
        if (this.profilingControl != null) {
            this.profilingControl.stop();
            this.profilingControl = null;
            this.data = null;
        }
    }
}

