/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.profiling.vm;

import com.sap.jvm.extension.java.base.ProfilingControl;
import com.sap.jvm.impl.extensions.WithExtensionsNativeLib;
import com.sap.jvm.impl.profiling.vm.OutputStreamImpl;
import com.sap.jvm.monitor.MonitoringPermission;
import com.sap.jvm.profiling.api.ProfilingVMInterface;
import com.sap.jvm.profiling.api.ProfilingVersion;
import com.sap.jvm.tracing.Trace;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ProfilingVMImpl
extends WithExtensionsNativeLib
implements ProfilingVMInterface {
    private ProfilingVersion version = null;

    @Override
    public OutputStream getOutputStream(String filePrefix) {
        return new OutputStreamImpl(filePrefix);
    }

    @Override
    public ProfilingVersion getVersion() {
        if (this.version == null) {
            try {
                MonitoringPermission.checkPermission(MonitoringPermission.READ_PERMISSION);
                DataInputStream stream = new DataInputStream(new ByteArrayInputStream(ProfilingVMImpl.getVmProfilingVersionInfo0()));
                int majorVersion = stream.readInt();
                int minorVersion = stream.readInt();
                int microVersion = stream.readInt();
                this.version = new ProfilingVersion(majorVersion, minorVersion, microVersion);
            }
            catch (IOException e) {
                Trace.get(ProfilingVMImpl.class).error((Throwable)e, "Unexpected exception during reading profiling version information.");
            }
        }
        return this.version;
    }

    @Override
    public void stopAllProfilingRuns() {
        ProfilingControl.stopAllProfilingRuns();
    }

    private static native byte[] getVmProfilingVersionInfo0();
}

