/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.session;

import java.security.AccessController;
import java.security.PrivilegedAction;

public class Configuration {
    public static int getPoolHandles(int def) {
        return Configuration.getOption("PoolHandles", def);
    }

    public static int getPoolLocks(int def) {
        return Configuration.getOption("PoolLocks", def);
    }

    public static int getInitialDomains(int def) {
        return Configuration.getOption("InitialDomains", def);
    }

    public static int getInitialSessionsPerDomain(int def) {
        return Configuration.getOption("InitialSessionsPerDomain", def);
    }

    public static int getInitialChunksPerSession(int def) {
        return Configuration.getOption("InitialChunksPerSession", def);
    }

    public static int getInitialBuffersPerChunk(int def) {
        return Configuration.getOption("InitialBuffersPerChunk", def);
    }

    public static int getChunkBufferSize(int def) {
        return Configuration.getOption("ChunkBufferSize", def);
    }

    public static int getLockSpinMax(int def) {
        return Configuration.getOption("LockSpinMax", def);
    }

    public static int getLockYieldMax(int def) {
        return Configuration.getOption("LockYieldMax", def);
    }

    public static int getLockNanoSleepMin(int def) {
        return Configuration.getOption("LockNanoSleepMin", def);
    }

    public static int getLockNanoSleepMax(int def) {
        return Configuration.getOption("LockNanoSleepMax", def);
    }

    public static int getHashLoadFactor(int def) {
        return Configuration.getOption("HashLoadFactor", def);
    }

    private static int getOption(final String name, final int def) {
        return AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                return Integer.valueOf(System.getProperty("com.sap.jvm.session." + name, Integer.toString(def)));
            }
        });
    }
}

