/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.session;

import com.sap.jvm.impl.session.SharedSessionChunkImpl;
import com.sap.jvm.session.SharedDataAccessException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

class SharedByteBufferInputStream
extends InputStream {
    private int sessionHandle;
    private int chunkId;
    private int bufIdx;
    private ByteBuffer[] buffers;

    SharedByteBufferInputStream(int sessionHandle, int chunkId) throws SharedDataAccessException {
        this.sessionHandle = sessionHandle;
        this.chunkId = chunkId;
        this.buffers = SharedSessionChunkImpl.getChunkBuffers(sessionHandle, chunkId);
    }

    @Override
    public int available() throws IOException {
        if (this.buffers.length == 0) {
            return 0;
        }
        ByteBuffer curBuf = this.buffers[this.bufIdx];
        int avail = curBuf.remaining();
        if (avail <= 0) {
            if (this.bufIdx + 1 >= this.buffers.length) {
                return 0;
            }
            curBuf = this.buffers[++this.bufIdx];
            curBuf.rewind();
            avail = curBuf.remaining();
        }
        return avail;
    }

    @Override
    public int read() throws IOException {
        if (this.buffers.length == 0) {
            return -1;
        }
        ByteBuffer curBuf = this.buffers[this.bufIdx];
        if (curBuf.remaining() <= 0) {
            if (this.bufIdx + 1 >= this.buffers.length) {
                return -1;
            }
            curBuf = this.buffers[++this.bufIdx];
            curBuf.rewind();
        }
        return curBuf.get() & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.buffers.length == 0) {
            return -1;
        }
        ByteBuffer curBuf = this.buffers[this.bufIdx];
        int avail = Math.min(len, curBuf.remaining());
        if (avail <= 0) {
            if (this.bufIdx + 1 >= this.buffers.length) {
                return -1;
            }
            curBuf = this.buffers[++this.bufIdx];
            curBuf.rewind();
            avail = Math.min(len, curBuf.remaining());
        }
        curBuf.get(b, off, avail);
        return avail;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.buffers.length == 0) {
            return 0L;
        }
        ByteBuffer curBuf = this.buffers[this.bufIdx];
        int avail = Math.min((int)n, curBuf.remaining());
        if (avail <= 0) {
            if (this.bufIdx + 1 >= this.buffers.length) {
                return 0L;
            }
            curBuf = this.buffers[++this.bufIdx];
            curBuf.rewind();
            avail = Math.min((int)n, curBuf.remaining());
        }
        curBuf.position(curBuf.position() + avail);
        return avail;
    }

    @Override
    public void close() throws IOException {
        SharedSessionChunkImpl.releaseChunkBuffers(this.sessionHandle, this.chunkId, null);
    }
}

