/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.session;

import com.sap.jvm.impl.session.Configuration;
import com.sap.jvm.impl.session.SharedSessionChunkImpl;
import com.sap.jvm.session.OutOfSharedMemoryException;
import com.sap.jvm.session.SharedDataAccessException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

class SharedByteBufferOutputStream
extends OutputStream {
    private int sessionHandle;
    private int chunkId;
    private static final int DEFAULT_BUFSIZE = 65536;
    private static final int BUFSIZE = Configuration.getChunkBufferSize(65536);
    private ByteBuffer curBuf;

    SharedByteBufferOutputStream(int sessionHandle, int chunkId) throws SharedDataAccessException, OutOfSharedMemoryException {
        this.sessionHandle = sessionHandle;
        this.chunkId = chunkId;
        this.curBuf = this.newBuffer(BUFSIZE);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int fits = this.curBuf.remaining();
        if (len <= fits) {
            this.curBuf.put(b, off, len);
        } else {
            this.curBuf.put(b, off, fits);
            int remainder = len - fits;
            this.newBuffer(remainder).put(b, off + fits, remainder);
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.curBuf.remaining() > 0) {
            this.curBuf.put((byte)b);
        } else {
            this.newBuffer(1).put((byte)b);
        }
    }

    private ByteBuffer newBuffer(int minSize) throws SharedDataAccessException, OutOfSharedMemoryException {
        int size = Math.max(minSize, BUFSIZE);
        this.curBuf = SharedSessionChunkImpl.newChunkBuffer(this.sessionHandle, this.chunkId, size);
        return this.curBuf;
    }

    @Override
    public void close() throws IOException {
        SharedSessionChunkImpl.releaseChunkBuffers(this.sessionHandle, this.chunkId, this.curBuf);
    }
}

