/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.session;

import com.sap.jvm.impl.session.Configuration;
import com.sap.jvm.impl.session.raw.Raw;
import com.sap.jvm.impl.session.raw.RawAddressArray;
import com.sap.jvm.impl.session.raw.RawItem;
import com.sap.jvm.impl.session.raw.RawLock;
import com.sap.jvm.impl.session.raw.RawSharedPool;
import com.sap.jvm.session.OutOfSharedMemoryException;
import com.sap.jvm.session.SharedDataAccessException;
import com.sap.jvm.session.SharedPool;
import jdk.internal.misc.Unsafe;

public class SharedPoolImpl
extends SharedPool {
    private static final Raw rawKlass = Raw.klass();
    private static final Unsafe unsafe = rawKlass.getUnsafe();
    private static final RawSharedPool rawSharedPoolKlass = RawSharedPool.klass();
    private static final RawLock.Array rawLockArrayKlass = RawLock.Array.klass();
    private static final RawItem rawItemKlass = RawItem.klass();
    private static final RawAddressArray rawAddressArrayKlass = RawAddressArray.klass();
    private static final int DEFAULT_HANDLE_FACTOR = 1024;
    private static final int DEFAULT_LOCK_FACTOR = 8;
    private static final long poolSize = rawKlass.getSharedPoolSize();
    private static final int log2NumHandles = SharedPoolImpl.log2RoundedUp(Configuration.getPoolHandles(SharedPoolImpl.handlesForSize(poolSize)));
    private static final int numHandles = 1 << log2NumHandles;
    private static final int handleMask = numHandles - 1;
    private static final int log2NumLocks = SharedPoolImpl.log2RoundedUp(Configuration.getPoolLocks(SharedPoolImpl.locksForHandles(numHandles)));
    private static final int numLocks = 1 << log2NumLocks;
    private static final int lockMask = numLocks - 1;
    static final long rawSharedPool = SharedPoolImpl.attachToSharedMemory();

    private SharedPoolImpl() {
        throw new InternalError("don't instantiate");
    }

    private static long attachToSharedMemory() throws UnsupportedOperationException {
        long root = rawKlass.getSharedPoolRoot();
        if (root == 0L) {
            throw new UnsupportedOperationException("disabled in VM");
        }
        long rawPool = unsafe.getAddress(root);
        if (rawPool != 0L) {
            return rawPool;
        }
        try {
            rawPool = rawSharedPoolKlass.create(numHandles, numLocks);
        }
        catch (OutOfSharedMemoryException e) {
            rawPool = 0L;
        }
        if (!rawKlass.compareAndSwapAddress(root, 0L, rawPool)) {
            rawSharedPoolKlass.destroy(rawPool);
            rawPool = unsafe.getAddress(root);
        }
        if (rawPool == 0L) {
            throw new InternalError("Can neither create shared pool nor attach to it - check pool size");
        }
        return rawPool;
    }

    public static int getSessionStoreHandle() {
        return RawSharedPool.SESSION_STORE_HANDLE;
    }

    public static void lockHandle(int handle) {
        rawLockArrayKlass.lock(rawSharedPoolKlass.getLocks(rawSharedPool), SharedPoolImpl.lock(handle));
    }

    public static void unlockHandle(int handle) {
        rawLockArrayKlass.unlock(rawSharedPoolKlass.getLocks(rawSharedPool), SharedPoolImpl.lock(handle));
    }

    static long getItem(int handle, int type) throws SharedDataAccessException {
        long rawHandles = rawSharedPoolKlass.getHandles(rawSharedPool);
        long rawItem = rawAddressArrayKlass.get(rawHandles, SharedPoolImpl.slot(handle));
        if (rawItem == 0L) {
            throw new SharedDataAccessException("no item with handle " + handle + " (slot " + SharedPoolImpl.slot(handle) + " empty)");
        }
        if (rawItemKlass.getHandle(rawItem) != handle) {
            throw new SharedDataAccessException("no item with handle " + handle + " (slot " + SharedPoolImpl.slot(handle) + " occupied by " + rawItemKlass.getHandle(rawItem) + ")");
        }
        if (rawItemKlass.getType(rawItem) != type) {
            throw new SharedDataAccessException("type mismatch for handle " + handle + ": expected " + type + ", got " + rawItemKlass.getType(rawItem));
        }
        return rawItem;
    }

    static int putItem(long rawItem) throws OutOfSharedMemoryException {
        int theirNextHandle;
        int handle;
        int slot;
        long rawHandles = rawSharedPoolKlass.getHandles(rawSharedPool);
        if (rawAddressArrayKlass.get(rawHandles, slot = SharedPoolImpl.slot(handle = rawSharedPoolKlass.getNextHandleVolatile(rawSharedPool))) == 0L && rawAddressArrayKlass.atomicSwap(rawHandles, slot, 0L, rawItem)) {
            rawItemKlass.setHandle(rawItem, handle);
            rawSharedPoolKlass.atomicAddFreeHandles(rawSharedPool, -1);
            rawSharedPoolKlass.atomicSwapNextHandle(rawSharedPool, handle, SharedPoolImpl.next(handle));
            return handle;
        }
        int startHandle = handle;
        do {
            handle = SharedPoolImpl.next(handle);
            if (rawSharedPoolKlass.getFreeHandlesVolatile(rawSharedPool) > 0) continue;
            throw new OutOfSharedMemoryException("out of handles");
        } while (rawAddressArrayKlass.get(rawHandles, slot = SharedPoolImpl.slot(handle)) != 0L || !rawAddressArrayKlass.atomicSwap(rawHandles, slot, 0L, rawItem));
        rawItemKlass.setHandle(rawItem, handle);
        rawSharedPoolKlass.atomicAddFreeHandles(rawSharedPool, -1);
        int ourNextHandle = SharedPoolImpl.next(handle);
        while (SharedPoolImpl.distance(startHandle, theirNextHandle = rawSharedPoolKlass.getNextHandleVolatile(rawSharedPool)) < SharedPoolImpl.distance(startHandle, ourNextHandle) && !rawSharedPoolKlass.atomicSwapNextHandle(rawSharedPool, theirNextHandle, ourNextHandle)) {
        }
        return handle;
    }

    static void removeItem(long rawItem, int handle) {
        long rawHandles = rawSharedPoolKlass.getHandles(rawSharedPool);
        if (rawAddressArrayKlass.atomicSwap(rawHandles, SharedPoolImpl.slot(handle), rawItem, 0L)) {
            rawSharedPoolKlass.atomicAddFreeHandles(rawSharedPool, 1);
        }
    }

    private static final int handlesForSize(long size) {
        long result = size / 1024L;
        if (result > 0x40000000L) {
            result = 0x40000000L;
        }
        return (int)result;
    }

    private static final int locksForHandles(int handles) {
        return handles / 8;
    }

    private static int log2RoundedUp(int size) {
        int log2 = 0;
        while (1 << log2 < size) {
            ++log2;
        }
        return log2;
    }

    private static int slot(int handle) {
        return handle & handleMask;
    }

    private static int lock(int handle) {
        return handle & lockMask;
    }

    private static int next(int handle) {
        return handle + 1 & Integer.MAX_VALUE;
    }

    private static int distance(int handle1, int handle2) {
        return handle2 - handle1 & Integer.MAX_VALUE;
    }
}

