/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.session;

import com.sap.jvm.impl.session.SharedByteBufferInputStream;
import com.sap.jvm.impl.session.SharedByteBufferOutputStream;
import com.sap.jvm.impl.session.SharedPoolImpl;
import com.sap.jvm.impl.session.SharedSessionChunkInputStream;
import com.sap.jvm.impl.session.SharedSessionChunkOutputStream;
import com.sap.jvm.impl.session.SharedSessionStoreImpl;
import com.sap.jvm.impl.session.raw.Raw;
import com.sap.jvm.impl.session.raw.RawAddressArray;
import com.sap.jvm.impl.session.raw.RawByteArray;
import com.sap.jvm.impl.session.raw.RawChunk;
import com.sap.jvm.impl.session.raw.RawSession;
import com.sap.jvm.session.DeserializationCallbackInterface;
import com.sap.jvm.session.OutOfSharedMemoryException;
import com.sap.jvm.session.SerializationCallbackInterface;
import com.sap.jvm.session.SharedDataAccessException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.nio.ByteBuffer;

public class SharedSessionChunkImpl {
    private static final RawSession rawSessionKlass = RawSession.klass();
    private static final RawChunk rawChunkKlass = RawChunk.klass();
    private static final RawByteArray rawByteArrayKlass = RawByteArray.klass();
    private static final RawAddressArray rawAddressArrayKlass = RawAddressArray.klass();
    private static final Raw rawKlass = Raw.klass();

    private SharedSessionChunkImpl() {
        throw new InternalError("don't instantiate");
    }

    public static String getChunkName(int sessionHandle, int chunkId) throws SharedDataAccessException {
        return SharedSessionStoreImpl.lookupChunkName(chunkId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getChunkSize(int sessionHandle, int chunkId) throws SharedDataAccessException {
        SharedPoolImpl.lockHandle(sessionHandle);
        try {
            long rawSession = SharedPoolImpl.getItem(sessionHandle, 3);
            long rawChunkArray = rawSessionKlass.getChunkArray(rawSession);
            long rawChunk = rawAddressArrayKlass.get(rawChunkArray, chunkId);
            if (rawChunk == 0L) {
                throw new SharedDataAccessException("no chunk with id " + chunkId);
            }
            long l = rawChunkKlass.getSize(rawChunk);
            return l;
        }
        finally {
            SharedPoolImpl.unlockHandle(sessionHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setContent(int sessionHandle, int chunkId, Object content, SerializationCallbackInterface callback) throws SharedDataAccessException, OutOfSharedMemoryException, IOException {
        SharedByteBufferOutputStream bbOut = null;
        ObjectOutputStream objOut = null;
        try {
            bbOut = new SharedByteBufferOutputStream(sessionHandle, chunkId);
            objOut = new SharedSessionChunkOutputStream(bbOut, callback);
            objOut.writeObject(content);
        }
        finally {
            if (objOut != null) {
                objOut.close();
            } else if (bbOut != null) {
                bbOut.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getContent(int sessionHandle, int chunkId, DeserializationCallbackInterface callback) throws SharedDataAccessException, IOException, ClassNotFoundException {
        SharedByteBufferInputStream bbIn = null;
        ObjectInputStream objIn = null;
        try {
            bbIn = new SharedByteBufferInputStream(sessionHandle, chunkId);
            if (bbIn.available() == 0) {
                Object var5_5 = null;
                return var5_5;
            }
            objIn = new SharedSessionChunkInputStream(bbIn, callback);
            callback.setBackDelegationCallback(new BackDelegationCallbackAdaptor((SharedSessionChunkInputStream)objIn));
            Object object = objIn.readObject();
            return object;
        }
        finally {
            if (objIn != null) {
                objIn.close();
            } else if (bbIn != null) {
                bbIn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ByteBuffer[] getChunkBuffers(int sessionHandle, int chunkId) throws SharedDataAccessException {
        SharedPoolImpl.lockHandle(sessionHandle);
        try {
            long rawSession = SharedPoolImpl.getItem(sessionHandle, 3);
            long rawChunkArray = rawSessionKlass.getChunkArray(rawSession);
            long rawChunk = rawAddressArrayKlass.get(rawChunkArray, chunkId);
            if (rawChunk == 0L) {
                throw new SharedDataAccessException("no chunk with id " + chunkId);
            }
            long gtid = rawKlass.getGlobalThreadId(Thread.currentThread().getId());
            long accessor = SharedSessionChunkImpl.getAccessorCheckingLiveness(rawChunk, gtid);
            if (accessor != 0L) {
                throw new SharedDataAccessException("chunk reserved by VM ID " + rawKlass.extractVmId(accessor) + ", VM unique ID " + rawKlass.extractVmUid(accessor) + ", thread ID " + rawKlass.extractThreadId(accessor));
            }
            rawChunkKlass.setAccessor(rawChunk, gtid);
            ByteBuffer[] byteBufferArray = SharedSessionChunkImpl.asByteBuffers(rawChunkKlass.getBuffers(rawChunk), rawChunkKlass.getNumBuffers(rawChunk));
            return byteBufferArray;
        }
        finally {
            SharedPoolImpl.unlockHandle(sessionHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ByteBuffer newChunkBuffer(int sessionHandle, int chunkId, int size) throws SharedDataAccessException, OutOfSharedMemoryException {
        SharedPoolImpl.lockHandle(sessionHandle);
        try {
            long rawSession = SharedPoolImpl.getItem(sessionHandle, 3);
            long rawChunkArray = rawSessionKlass.getChunkArray(rawSession);
            long rawChunk = rawAddressArrayKlass.get(rawChunkArray, chunkId);
            if (rawChunk == 0L) {
                throw new SharedDataAccessException("no chunk with id " + chunkId);
            }
            int numBuffers = rawChunkKlass.getNumBuffers(rawChunk);
            long rawBuffers = rawChunkKlass.getBuffers(rawChunk);
            long gtid = rawKlass.getGlobalThreadId(Thread.currentThread().getId());
            long accessor = SharedSessionChunkImpl.getAccessorCheckingLiveness(rawChunk, gtid);
            if (accessor == 0L) {
                rawChunkKlass.setAccessor(rawChunk, gtid);
                for (int i = 0; i < numBuffers; ++i) {
                    rawByteArrayKlass.destroy(rawAddressArrayKlass.get(rawBuffers, i));
                    rawAddressArrayKlass.set(rawBuffers, i, 0L);
                }
                numBuffers = 0;
                rawChunkKlass.setNumBuffers(rawChunk, numBuffers);
                long oldSize = rawChunkKlass.getSize(rawChunk);
                rawSessionKlass.setTotalSize(rawSession, rawSessionKlass.getTotalSize(rawSession) - oldSize);
                rawChunkKlass.setSize(rawChunk, 0L);
            } else if (accessor != gtid) {
                throw new SharedDataAccessException("chunk reserved by VM ID " + rawKlass.extractVmId(accessor) + ", VM unique ID " + rawKlass.extractVmUid(accessor) + ", thread ID " + rawKlass.extractThreadId(accessor));
            }
            int length = rawAddressArrayKlass.length(rawBuffers);
            if (numBuffers + 1 >= length) {
                rawBuffers = rawAddressArrayKlass.resize(rawBuffers, length * 2);
                rawChunkKlass.setBuffers(rawChunk, rawBuffers);
            }
            long rawBuffer = rawByteArrayKlass.create(size);
            rawAddressArrayKlass.set(rawBuffers, numBuffers, rawBuffer);
            rawChunkKlass.setNumBuffers(rawChunk, numBuffers + 1);
            rawChunkKlass.setSize(rawChunk, rawChunkKlass.getSize(rawChunk) + (long)size);
            rawSessionKlass.setTotalSize(rawSession, rawSessionKlass.getTotalSize(rawSession) + (long)size);
            ByteBuffer byteBuffer = SharedSessionChunkImpl.asByteBuffer(rawBuffer);
            return byteBuffer;
        }
        finally {
            SharedPoolImpl.unlockHandle(sessionHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void releaseChunkBuffers(int sessionHandle, int chunkId, ByteBuffer curBuf) throws SharedDataAccessException, OutOfSharedMemoryException {
        SharedPoolImpl.lockHandle(sessionHandle);
        try {
            long rawSession = SharedPoolImpl.getItem(sessionHandle, 3);
            long rawChunkArray = rawSessionKlass.getChunkArray(rawSession);
            long rawChunk = rawAddressArrayKlass.get(rawChunkArray, chunkId);
            if (rawChunk == 0L) {
                throw new SharedDataAccessException("no chunk with id " + chunkId);
            }
            long gtid = rawKlass.getGlobalThreadId(Thread.currentThread().getId());
            long accessor = SharedSessionChunkImpl.getAccessorCheckingLiveness(rawChunk, gtid);
            if (accessor == 0L) {
                return;
            }
            if (accessor != gtid) {
                throw new IllegalStateException("chunk not reserved by this thread but by VM ID " + rawKlass.extractVmId(accessor) + ", VM unique ID " + rawKlass.extractVmUid(accessor) + ", thread ID " + rawKlass.extractThreadId(accessor));
            }
            if (curBuf != null) {
                long rawBuffers = rawChunkKlass.getBuffers(rawChunk);
                int numBuffers = rawChunkKlass.getNumBuffers(rawChunk);
                long rawBuffer = rawAddressArrayKlass.get(rawBuffers, numBuffers - 1);
                int oldLength = rawByteArrayKlass.length(rawBuffer);
                int newLength = curBuf.position();
                rawBuffer = rawByteArrayKlass.resize(rawBuffer, newLength);
                rawAddressArrayKlass.set(rawBuffers, numBuffers - 1, rawBuffer);
                rawChunkKlass.setSize(rawChunk, rawChunkKlass.getSize(rawChunk) + (long)newLength - (long)oldLength);
                rawSessionKlass.setTotalSize(rawSession, rawSessionKlass.getTotalSize(rawSession) + (long)newLength - (long)oldLength);
            }
            rawChunkKlass.setAccessor(rawChunk, 0L);
        }
        finally {
            SharedPoolImpl.unlockHandle(sessionHandle);
        }
    }

    private static long getAccessorCheckingLiveness(long rawChunk, long gtid) {
        long accessor = rawChunkKlass.getAccessor(rawChunk);
        if (accessor != 0L && accessor != gtid && !rawKlass.isValidGlobalThreadId(accessor)) {
            rawChunkKlass.setAccessor(rawChunk, 0L);
            accessor = 0L;
        }
        return accessor;
    }

    private static ByteBuffer[] asByteBuffers(long rawBuffers, int numBuffers) {
        ByteBuffer[] buffers = new ByteBuffer[numBuffers];
        for (int i = 0; i < numBuffers; ++i) {
            buffers[i] = SharedSessionChunkImpl.asByteBuffer(rawAddressArrayKlass.get(rawBuffers, i));
        }
        return buffers;
    }

    private static ByteBuffer asByteBuffer(long rawBuffer) {
        return rawKlass.createDirectByteBuffer(rawByteArrayKlass.getAddr(rawBuffer, 0), rawByteArrayKlass.length(rawBuffer));
    }

    private static class BackDelegationCallbackAdaptor
    implements DeserializationCallbackInterface {
        private final SharedSessionChunkInputStream inputStream;

        BackDelegationCallbackAdaptor(SharedSessionChunkInputStream inputStream) {
            this.inputStream = inputStream;
        }

        @Override
        public Class<?> resolveClass(ObjectStreamClass desc, Object annotation) throws ClassNotFoundException, IOException {
            return this.inputStream.delegateResolveClass(desc);
        }

        @Override
        public Object resolveObject(Object obj) {
            throw new InternalError("should not be called");
        }

        @Override
        public Class<?> resolveProxyClass(String[] interfaces, Object annotation) throws ClassNotFoundException, IOException {
            return this.inputStream.delegateResolveProxyClass(interfaces);
        }

        @Override
        public void setBackDelegationCallback(DeserializationCallbackInterface backDelegationCallback) {
            throw new InternalError("should not be called");
        }
    }
}

