/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.session;

import com.sap.jvm.session.DeserializationCallbackInterface;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.security.AccessController;
import java.security.PrivilegedAction;

class SharedSessionChunkInputStream
extends ObjectInputStream {
    private DeserializationCallbackInterface callback;

    SharedSessionChunkInputStream(InputStream in, DeserializationCallbackInterface callback) throws IOException {
        super(in);
        this.callback = callback;
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                SharedSessionChunkInputStream.this.enableResolveObject(true);
                return null;
            }
        });
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        Object annotation = this.readObject();
        return this.callback.resolveClass(desc, annotation);
    }

    @Override
    protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        Object annotation = this.readObject();
        return this.callback.resolveProxyClass(interfaces, annotation);
    }

    @Override
    protected Object resolveObject(Object obj) throws IOException {
        return this.callback.resolveObject(obj);
    }

    Class<?> delegateResolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        return super.resolveClass(desc);
    }

    Class<?> delegateResolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        return super.resolveProxyClass(interfaces);
    }
}

