/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.session;

import com.sap.jvm.impl.session.SharedPoolImpl;
import com.sap.jvm.impl.session.SharedSessionImpl;
import com.sap.jvm.impl.session.raw.RawDomain;
import com.sap.jvm.impl.session.raw.RawHashMap;
import com.sap.jvm.impl.session.raw.RawSession;
import com.sap.jvm.impl.session.raw.RawString;
import com.sap.jvm.session.OutOfSharedMemoryException;
import com.sap.jvm.session.SharedDataAccessException;

public class SharedSessionDomainImpl {
    private static final RawString rawStringKlass = RawString.klass();
    private static final RawSession rawSessionKlass = RawSession.klass();
    private static final RawHashMap rawHashMapKlass = RawHashMap.klass();
    private static final RawDomain rawDomainKlass = RawDomain.klass();

    private SharedSessionDomainImpl() {
        throw new InternalError("don't instantiate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int createSession(int domainHandle, String name) throws SharedDataAccessException, OutOfSharedMemoryException {
        SharedPoolImpl.lockHandle(domainHandle);
        try {
            long rawDomain = SharedPoolImpl.getItem(domainHandle, 2);
            long rawSessionMap = rawDomainKlass.getSessionMap(rawDomain);
            long rawSession = rawHashMapKlass.get(rawSessionMap, name);
            if (rawSession != 0L) {
                int n = -1;
                return n;
            }
            rawSession = rawSessionKlass.create(name);
            try {
                SharedPoolImpl.putItem(rawSession);
                rawHashMapKlass.put(rawSessionMap, rawSession);
            }
            catch (OutOfSharedMemoryException e) {
                rawSessionKlass.destroy(rawSession);
                throw e;
            }
            int n = rawSessionKlass.getHandle(rawSession);
            return n;
        }
        finally {
            SharedPoolImpl.unlockHandle(domainHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getSession(int domainHandle, String name) throws SharedDataAccessException {
        SharedPoolImpl.lockHandle(domainHandle);
        try {
            long rawDomain = SharedPoolImpl.getItem(domainHandle, 2);
            long rawSessionMap = rawDomainKlass.getSessionMap(rawDomain);
            long rawSession = rawHashMapKlass.get(rawSessionMap, name);
            if (rawSession == 0L) {
                int n = -1;
                return n;
            }
            int n = rawSessionKlass.getHandle(rawSession);
            return n;
        }
        finally {
            SharedPoolImpl.unlockHandle(domainHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroySession(int domainHandle, int sessionHandle) {
        long rawSessionToDelete = 0L;
        SharedPoolImpl.lockHandle(domainHandle);
        try {
            long rawDomain = SharedPoolImpl.getItem(domainHandle, 2);
            long rawSessionMap = rawDomainKlass.getSessionMap(rawDomain);
            long rawSession = SharedPoolImpl.getItem(sessionHandle, 3);
            if (rawHashMapKlass.remove(rawSessionMap, rawSession)) {
                rawSessionToDelete = rawSession;
            }
        }
        catch (SharedDataAccessException e) {
            return;
        }
        finally {
            SharedPoolImpl.unlockHandle(domainHandle);
        }
        if (rawSessionToDelete != 0L) {
            SharedPoolImpl.lockHandle(sessionHandle);
            try {
                rawSessionKlass.setDeleted(rawSessionToDelete, true);
                SharedSessionImpl.tryDeferredSessionDeletion(rawSessionToDelete, sessionHandle);
            }
            finally {
                SharedPoolImpl.unlockHandle(sessionHandle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getSessionHandles(int domainHandle) throws SharedDataAccessException {
        SharedPoolImpl.lockHandle(domainHandle);
        try {
            long rawDomain = SharedPoolImpl.getItem(domainHandle, 2);
            long rawSessionMap = rawDomainKlass.getSessionMap(rawDomain);
            int[] nArray = rawHashMapKlass.getAllHandles(rawSessionMap);
            return nArray;
        }
        finally {
            SharedPoolImpl.unlockHandle(domainHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDomainName(int domainHandle) throws SharedDataAccessException {
        SharedPoolImpl.lockHandle(domainHandle);
        try {
            long rawDomain = SharedPoolImpl.getItem(domainHandle, 2);
            String string = rawStringKlass.asJavaString(rawDomainKlass.getName(rawDomain));
            return string;
        }
        finally {
            SharedPoolImpl.unlockHandle(domainHandle);
        }
    }
}

