/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.session;

import com.sap.jvm.impl.session.SharedPoolImpl;
import com.sap.jvm.impl.session.SharedSessionStoreImpl;
import com.sap.jvm.impl.session.raw.RawAddressArray;
import com.sap.jvm.impl.session.raw.RawChunk;
import com.sap.jvm.impl.session.raw.RawSession;
import com.sap.jvm.impl.session.raw.RawString;
import com.sap.jvm.session.OutOfSharedMemoryException;
import com.sap.jvm.session.SharedDataAccessException;

public class SharedSessionImpl {
    private static final RawString rawStringKlass = RawString.klass();
    private static final RawSession rawSessionKlass = RawSession.klass();
    private static final RawChunk rawChunkKlass = RawChunk.klass();
    private static final RawAddressArray rawAddressArrayKlass = RawAddressArray.klass();

    private SharedSessionImpl() {
        throw new InternalError("don't instantiate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int createChunk(int sessionHandle, String name) throws SharedDataAccessException, OutOfSharedMemoryException {
        int chunkId = SharedSessionStoreImpl.lookupChunkId(name);
        SharedPoolImpl.lockHandle(sessionHandle);
        try {
            long rawSession = SharedPoolImpl.getItem(sessionHandle, 3);
            long rawChunkArray = rawSessionKlass.getChunkArray(rawSession);
            int length = rawAddressArrayKlass.length(rawChunkArray);
            if (chunkId >= length) {
                rawChunkArray = rawAddressArrayKlass.resize(rawChunkArray, chunkId + 1);
                rawSessionKlass.setChunkArray(rawSession, rawChunkArray);
            }
            if (rawAddressArrayKlass.get(rawChunkArray, chunkId) != 0L) {
                int n = -1;
                return n;
            }
            rawAddressArrayKlass.set(rawChunkArray, chunkId, rawChunkKlass.create());
            int n = chunkId;
            return n;
        }
        finally {
            SharedPoolImpl.unlockHandle(sessionHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getChunk(int sessionHandle, String name) throws SharedDataAccessException {
        int chunkId = -1;
        try {
            chunkId = SharedSessionStoreImpl.lookupChunkId(name);
        }
        catch (OutOfSharedMemoryException e) {
            return -1;
        }
        SharedPoolImpl.lockHandle(sessionHandle);
        try {
            long rawSession = SharedPoolImpl.getItem(sessionHandle, 3);
            long rawChunkArray = rawSessionKlass.getChunkArray(rawSession);
            int length = rawAddressArrayKlass.length(rawChunkArray);
            if (chunkId >= length || rawAddressArrayKlass.get(rawChunkArray, chunkId) == 0L) {
                int n = -1;
                return n;
            }
            int n = chunkId;
            return n;
        }
        finally {
            SharedPoolImpl.unlockHandle(sessionHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyChunk(int sessionHandle, int chunkId) {
        SharedPoolImpl.lockHandle(sessionHandle);
        try {
            long rawSession = SharedPoolImpl.getItem(sessionHandle, 3);
            long rawChunkArray = rawSessionKlass.getChunkArray(rawSession);
            int length = rawAddressArrayKlass.length(rawChunkArray);
            if (chunkId >= length) {
                return;
            }
            long rawChunk = rawAddressArrayKlass.get(rawChunkArray, chunkId);
            if (rawChunk == 0L) {
                return;
            }
            if (rawChunkKlass.getAccessor(rawChunk) != 0L) {
                return;
            }
            long size = rawChunkKlass.getSize(rawChunk);
            rawSessionKlass.setTotalSize(rawSession, rawSessionKlass.getTotalSize(rawSession) - size);
            rawChunkKlass.destroy(rawChunk);
            rawAddressArrayKlass.set(rawChunkArray, chunkId, 0L);
        }
        catch (SharedDataAccessException e) {
            return;
        }
        finally {
            SharedPoolImpl.unlockHandle(sessionHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getChunkIds(int sessionHandle) throws SharedDataAccessException {
        SharedPoolImpl.lockHandle(sessionHandle);
        try {
            long rawSession = SharedPoolImpl.getItem(sessionHandle, 3);
            long rawChunkArray = rawSessionKlass.getChunkArray(rawSession);
            int length = rawAddressArrayKlass.length(rawChunkArray);
            int[] chunkIds = new int[length];
            int numChunkIds = 0;
            for (int i = 0; i < length; ++i) {
                long rawChunk = rawAddressArrayKlass.get(rawChunkArray, i);
                if (rawChunk == 0L) continue;
                chunkIds[numChunkIds++] = i;
            }
            if (numChunkIds != chunkIds.length) {
                int[] trimmedChunkIds = new int[numChunkIds];
                for (int i = 0; i < numChunkIds; ++i) {
                    trimmedChunkIds[i] = chunkIds[i];
                }
                int[] nArray = trimmedChunkIds;
                return nArray;
            }
            int[] nArray = chunkIds;
            return nArray;
        }
        finally {
            SharedPoolImpl.unlockHandle(sessionHandle);
        }
    }

    static void tryDeferredSessionDeletion(long rawSession, int sessionHandle) {
        long rawChunkArray = rawSessionKlass.getChunkArray(rawSession);
        int numChunks = rawAddressArrayKlass.length(rawChunkArray);
        for (int i = 0; i < numChunks; ++i) {
            long rawChunk = rawAddressArrayKlass.get(rawChunkArray, i);
            if (rawChunk == 0L) continue;
            if (rawChunkKlass.getAccessor(rawChunk) != 0L) {
                return;
            }
            rawChunkKlass.destroy(rawChunk);
            rawAddressArrayKlass.set(rawChunkArray, i, 0L);
        }
        SharedPoolImpl.removeItem(rawSession, sessionHandle);
        rawSessionKlass.destroy(rawSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSessionName(int sessionHandle) throws SharedDataAccessException {
        SharedPoolImpl.lockHandle(sessionHandle);
        try {
            long rawSession = SharedPoolImpl.getItem(sessionHandle, 3);
            String string = rawStringKlass.asJavaString(rawSessionKlass.getName(rawSession));
            return string;
        }
        finally {
            SharedPoolImpl.unlockHandle(sessionHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getCreationTime(int sessionHandle) throws SharedDataAccessException {
        SharedPoolImpl.lockHandle(sessionHandle);
        try {
            long rawSession = SharedPoolImpl.getItem(sessionHandle, 3);
            long l = rawSessionKlass.getCreationTime(rawSession);
            return l;
        }
        finally {
            SharedPoolImpl.unlockHandle(sessionHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCreationTime(int sessionHandle, long creationTime) throws SharedDataAccessException {
        SharedPoolImpl.lockHandle(sessionHandle);
        try {
            long rawSession = SharedPoolImpl.getItem(sessionHandle, 3);
            rawSessionKlass.setCreationTime(rawSession, creationTime);
        }
        finally {
            SharedPoolImpl.unlockHandle(sessionHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getTimeoutPeriod(int sessionHandle) throws SharedDataAccessException {
        SharedPoolImpl.lockHandle(sessionHandle);
        try {
            long rawSession = SharedPoolImpl.getItem(sessionHandle, 3);
            long l = rawSessionKlass.getTimeoutPeriod(rawSession);
            return l;
        }
        finally {
            SharedPoolImpl.unlockHandle(sessionHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTimeoutPeriod(int sessionHandle, long timeoutPeriod) throws SharedDataAccessException {
        SharedPoolImpl.lockHandle(sessionHandle);
        try {
            long rawSession = SharedPoolImpl.getItem(sessionHandle, 3);
            rawSessionKlass.setTimeoutPeriod(rawSession, timeoutPeriod);
        }
        finally {
            SharedPoolImpl.unlockHandle(sessionHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getExpirationTime(int sessionHandle) throws SharedDataAccessException {
        SharedPoolImpl.lockHandle(sessionHandle);
        try {
            long rawSession = SharedPoolImpl.getItem(sessionHandle, 3);
            long l = rawSessionKlass.getExpirationTime(rawSession);
            return l;
        }
        finally {
            SharedPoolImpl.unlockHandle(sessionHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setExpirationTime(int sessionHandle, long expirationTime) throws SharedDataAccessException {
        SharedPoolImpl.lockHandle(sessionHandle);
        try {
            long rawSession = SharedPoolImpl.getItem(sessionHandle, 3);
            rawSessionKlass.setExpirationTime(rawSession, expirationTime);
        }
        finally {
            SharedPoolImpl.unlockHandle(sessionHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getTotalSize(int sessionHandle) throws SharedDataAccessException {
        SharedPoolImpl.lockHandle(sessionHandle);
        try {
            long rawSession = SharedPoolImpl.getItem(sessionHandle, 3);
            long l = rawSessionKlass.getTotalSize(rawSession);
            return l;
        }
        finally {
            SharedPoolImpl.unlockHandle(sessionHandle);
        }
    }
}

