/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.session;

import com.sap.jvm.impl.session.SharedPoolImpl;
import com.sap.jvm.impl.session.SharedSessionChunkImpl;
import com.sap.jvm.impl.session.SharedSessionDomainImpl;
import com.sap.jvm.impl.session.SharedSessionImpl;
import com.sap.jvm.impl.session.raw.RawAddressArray;
import com.sap.jvm.impl.session.raw.RawDomain;
import com.sap.jvm.impl.session.raw.RawHashMap;
import com.sap.jvm.impl.session.raw.RawSessionStore;
import com.sap.jvm.impl.session.raw.RawString;
import com.sap.jvm.session.DeserializationCallback;
import com.sap.jvm.session.DeserializationCallbackInterface;
import com.sap.jvm.session.OutOfSharedMemoryException;
import com.sap.jvm.session.SerializationCallback;
import com.sap.jvm.session.SerializationCallbackInterface;
import com.sap.jvm.session.SharedDataAccessException;
import com.sap.jvm.session.SharedSessionChunk;
import com.sap.jvm.session.SharedSessionStoreImplInterface;
import java.io.IOException;
import java.io.ObjectStreamClass;
import java.util.concurrent.ConcurrentHashMap;

public class SharedSessionStoreImpl
implements SharedSessionStoreImplInterface {
    private static final RawString rawStringKlass = RawString.klass();
    private static final RawSessionStore rawSessionStoreKlass = RawSessionStore.klass();
    private static final RawHashMap rawHashMapKlass = RawHashMap.klass();
    private static final RawDomain rawDomainKlass = RawDomain.klass();
    private static final RawAddressArray rawAddressArrayKlass = RawAddressArray.klass();
    private static final int sessionStoreHandle = SharedPoolImpl.getSessionStoreHandle();
    private static final long rawSessionStore = SharedSessionStoreImpl.getRawSessionStore();
    private static ConcurrentHashMap<String, Integer> chunkIds = new ConcurrentHashMap(10, 1.0f, 1);
    private static ConcurrentHashMap<Integer, String> chunkNames = new ConcurrentHashMap(10, 1.0f, 1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int createDomain(String name) throws OutOfSharedMemoryException {
        SharedPoolImpl.lockHandle(sessionStoreHandle);
        try {
            long rawDomainMap = rawSessionStoreKlass.getDomainMap(rawSessionStore);
            long rawDomain = rawHashMapKlass.get(rawDomainMap, name);
            if (rawDomain != 0L) {
                int n = -1;
                return n;
            }
            rawDomain = rawDomainKlass.create(name);
            try {
                SharedPoolImpl.putItem(rawDomain);
                rawHashMapKlass.put(rawDomainMap, rawDomain);
            }
            catch (OutOfSharedMemoryException e) {
                rawDomainKlass.destroy(rawDomain);
                throw e;
            }
            int n = rawDomainKlass.getHandle(rawDomain);
            return n;
        }
        finally {
            SharedPoolImpl.unlockHandle(sessionStoreHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDomain(String name) {
        SharedPoolImpl.lockHandle(sessionStoreHandle);
        try {
            long rawDomainMap = rawSessionStoreKlass.getDomainMap(rawSessionStore);
            long rawDomain = rawHashMapKlass.get(rawDomainMap, name);
            if (rawDomain == 0L) {
                int n = -1;
                return n;
            }
            int n = rawDomainKlass.getHandle(rawDomain);
            return n;
        }
        finally {
            SharedPoolImpl.unlockHandle(sessionStoreHandle);
        }
    }

    @Override
    public String getDomainName(int domainHandle) throws SharedDataAccessException {
        return SharedSessionDomainImpl.getDomainName(domainHandle);
    }

    @Override
    public int[] getDomainHandles() {
        SharedPoolImpl.lockHandle(sessionStoreHandle);
        try {
            int[] nArray = rawHashMapKlass.getAllHandles(rawSessionStoreKlass.getDomainMap(rawSessionStore));
            return nArray;
        }
        finally {
            SharedPoolImpl.unlockHandle(sessionStoreHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyDomain(int domainHandle) {
        try {
            int[] sessions;
            for (int sessionHandle : sessions = SharedSessionDomainImpl.getSessionHandles(domainHandle)) {
                SharedSessionDomainImpl.destroySession(domainHandle, sessionHandle);
            }
        }
        catch (SharedDataAccessException e) {
            return;
        }
        long rawDomainToDelete = 0L;
        SharedPoolImpl.lockHandle(sessionStoreHandle);
        try {
            long rawDomainMap = rawSessionStoreKlass.getDomainMap(rawSessionStore);
            long rawDomain = SharedPoolImpl.getItem(domainHandle, 2);
            if (rawHashMapKlass.remove(rawDomainMap, rawDomain)) {
                rawDomainToDelete = rawDomain;
            }
        }
        catch (SharedDataAccessException e) {
            return;
        }
        finally {
            SharedPoolImpl.unlockHandle(sessionStoreHandle);
        }
        if (rawDomainToDelete != 0L) {
            SharedPoolImpl.lockHandle(domainHandle);
            try {
                SharedPoolImpl.removeItem(rawDomainToDelete, domainHandle);
                rawDomainKlass.destroy(rawDomainToDelete);
            }
            finally {
                SharedPoolImpl.unlockHandle(domainHandle);
            }
        }
    }

    @Override
    public int createSession(int domainHandle, String name) throws SharedDataAccessException, OutOfSharedMemoryException {
        return SharedSessionDomainImpl.createSession(domainHandle, name);
    }

    @Override
    public int getSession(int domainHandle, String name) throws SharedDataAccessException {
        return SharedSessionDomainImpl.getSession(domainHandle, name);
    }

    @Override
    public String getSessionName(int sessionHandle) throws SharedDataAccessException {
        return SharedSessionImpl.getSessionName(sessionHandle);
    }

    @Override
    public int[] getSessionHandles(int domainHandle) throws SharedDataAccessException {
        return SharedSessionDomainImpl.getSessionHandles(domainHandle);
    }

    @Override
    public void destroySession(int domainHandle, int sessionHandle) {
        SharedSessionDomainImpl.destroySession(domainHandle, sessionHandle);
    }

    @Override
    public long getSessionCreationTime(int sessionHandle) throws SharedDataAccessException {
        return SharedSessionImpl.getCreationTime(sessionHandle);
    }

    @Override
    public void setSessionCreationTime(int sessionHandle, long creationTime) throws SharedDataAccessException {
        SharedSessionImpl.setCreationTime(sessionHandle, creationTime);
    }

    @Override
    public long getSessionTimeoutPeriod(int sessionHandle) throws SharedDataAccessException {
        return SharedSessionImpl.getTimeoutPeriod(sessionHandle);
    }

    @Override
    public void setSessionTimeoutPeriod(int sessionHandle, long timeoutPeriod) throws SharedDataAccessException {
        SharedSessionImpl.setTimeoutPeriod(sessionHandle, timeoutPeriod);
    }

    @Override
    public long getSessionExpirationTime(int sessionHandle) throws SharedDataAccessException {
        return SharedSessionImpl.getExpirationTime(sessionHandle);
    }

    @Override
    public void setSessionExpirationTime(int sessionHandle, long expirationTime) throws SharedDataAccessException {
        SharedSessionImpl.setExpirationTime(sessionHandle, expirationTime);
    }

    @Override
    public long getSessionTotalSize(int sessionHandle) throws SharedDataAccessException {
        return SharedSessionImpl.getTotalSize(sessionHandle);
    }

    @Override
    public int createChunk(int sessionHandle, String name) throws SharedDataAccessException, OutOfSharedMemoryException {
        return SharedSessionImpl.createChunk(sessionHandle, name);
    }

    @Override
    public int getChunk(int sessionHandle, String name) throws SharedDataAccessException {
        return SharedSessionImpl.getChunk(sessionHandle, name);
    }

    @Override
    public String getChunkName(int sessionHandle, int chunkId) throws SharedDataAccessException {
        return SharedSessionChunkImpl.getChunkName(sessionHandle, chunkId);
    }

    @Override
    public int[] getChunkIds(int sessionHandle) throws SharedDataAccessException {
        return SharedSessionImpl.getChunkIds(sessionHandle);
    }

    @Override
    public void destroyChunk(int sessionHandle, int chunkId) {
        SharedSessionImpl.destroyChunk(sessionHandle, chunkId);
    }

    @Override
    public long getChunkSize(int sessionHandle, int chunkId) throws SharedDataAccessException {
        return SharedSessionChunkImpl.getChunkSize(sessionHandle, chunkId);
    }

    @Override
    public void setChunkContent(int sessionHandle, int chunkId, Object content, SerializationCallback callback, SharedSessionChunk callbackChunk) throws SharedDataAccessException, OutOfSharedMemoryException, IOException {
        SharedSessionChunkImpl.setContent(sessionHandle, chunkId, content, new SerializationCallbackAdaptor(callback, callbackChunk));
    }

    @Override
    public Object getChunkContent(int sessionHandle, int chunkId, DeserializationCallback callback, SharedSessionChunk callbackChunk) throws SharedDataAccessException, IOException, ClassNotFoundException {
        return SharedSessionChunkImpl.getContent(sessionHandle, chunkId, new DeserializationCallbackAdaptor(callback, callbackChunk));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int lookupChunkId(String chunkName) throws OutOfSharedMemoryException {
        Integer chunkId = chunkIds.get(chunkName);
        if (chunkId != null) {
            return chunkId;
        }
        SharedPoolImpl.lockHandle(sessionStoreHandle);
        try {
            int numChunkNames = rawSessionStoreKlass.getNumChunkNames(rawSessionStore);
            long rawChunkNames = rawSessionStoreKlass.getChunkNames(rawSessionStore);
            for (int i = 0; i < numChunkNames; ++i) {
                long rawChunkName = rawAddressArrayKlass.get(rawChunkNames, i);
                String chunkNameAsString = rawStringKlass.asJavaString(rawChunkName);
                chunkIds.putIfAbsent(chunkNameAsString, i);
                chunkNames.putIfAbsent(i, chunkNameAsString);
            }
            chunkId = chunkIds.get(chunkName);
            if (chunkId != null) {
                int n = chunkId;
                return n;
            }
            chunkId = rawSessionStoreKlass.addChunkName(rawSessionStore, chunkName);
            chunkIds.put(chunkName, chunkId);
            chunkNames.put(chunkId, chunkName);
        }
        finally {
            SharedPoolImpl.unlockHandle(sessionStoreHandle);
        }
        return chunkId;
    }

    public static String lookupChunkName(int chunkId) throws SharedDataAccessException {
        String chunkName = chunkNames.get(chunkId);
        if (chunkName != null) {
            return chunkName;
        }
        SharedPoolImpl.lockHandle(sessionStoreHandle);
        try {
            int numChunkNames = rawSessionStoreKlass.getNumChunkNames(rawSessionStore);
            if (chunkId >= numChunkNames) {
                throw new SharedDataAccessException("invalid chunk id " + chunkId);
            }
            long rawChunkNames = rawSessionStoreKlass.getChunkNames(rawSessionStore);
            for (int i = 0; i < numChunkNames; ++i) {
                long rawChunkName = rawAddressArrayKlass.get(rawChunkNames, i);
                String chunkNameAsString = rawStringKlass.asJavaString(rawChunkName);
                chunkIds.putIfAbsent(chunkNameAsString, i);
                chunkNames.putIfAbsent(i, chunkNameAsString);
            }
            chunkName = chunkNames.get(chunkId);
            if (chunkName != null) {
                String string = chunkName;
                return string;
            }
            throw new InternalError("inconsistent shared session pool: missing chunk id " + chunkId + ", numChunkNames = " + numChunkNames);
        }
        finally {
            SharedPoolImpl.unlockHandle(sessionStoreHandle);
        }
    }

    private static long getRawSessionStore() {
        try {
            return SharedPoolImpl.getItem(sessionStoreHandle, 1);
        }
        catch (SharedDataAccessException e) {
            InternalError ie = new InternalError("inconsistent shared session pool: could not get raw session store");
            ie.initCause(e);
            throw ie;
        }
    }

    private static class DeserializationCallbackAdaptor
    implements DeserializationCallbackInterface {
        private final SharedSessionChunk callbackChunk;
        private final DeserializationCallback callback;

        DeserializationCallbackAdaptor(DeserializationCallback callback, SharedSessionChunk callbackChunk) {
            this.callback = callback;
            this.callbackChunk = callbackChunk;
        }

        @Override
        public Class<?> resolveClass(ObjectStreamClass desc, Object annotation) throws ClassNotFoundException, IOException {
            return this.callback.resolveClass(this.callbackChunk, desc, annotation);
        }

        @Override
        public Object resolveObject(Object obj) {
            return this.callback.resolveObject(this.callbackChunk, obj);
        }

        @Override
        public Class<?> resolveProxyClass(String[] interfaces, Object annotation) throws ClassNotFoundException, IOException {
            return this.callback.resolveProxyClass(this.callbackChunk, interfaces, annotation);
        }

        @Override
        public void setBackDelegationCallback(DeserializationCallbackInterface backDelegationCallback) {
            this.callbackChunk.setBackDelegationCallback(backDelegationCallback);
        }
    }

    private static class SerializationCallbackAdaptor
    implements SerializationCallbackInterface {
        private final SharedSessionChunk callbackChunk;
        private final SerializationCallback callback;

        SerializationCallbackAdaptor(SerializationCallback callback, SharedSessionChunk callbackChunk) {
            this.callback = callback;
            this.callbackChunk = callbackChunk;
        }

        @Override
        public Object annotateClass(Class<?> cl) {
            return this.callback.annotateClass(this.callbackChunk, cl);
        }

        @Override
        public Object annotateProxyClass(Class<?> cl) {
            return this.callback.annotateProxyClass(this.callbackChunk, cl);
        }

        @Override
        public Object replaceObject(Object obj) {
            return this.callback.replaceObject(this.callbackChunk, obj);
        }
    }
}

