/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.session.raw;

import com.sap.jvm.impl.session.SharedPoolImpl;
import com.sap.jvm.impl.session.raw.RawSharedPool;
import com.sap.jvm.session.OutOfSharedMemoryException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import jdk.internal.misc.Unsafe;
import jdk.internal.reflect.CallerSensitive;
import jdk.internal.reflect.Reflection;

public final class Raw {
    protected static ClassLoader platformClassLoader = null;
    private static final Raw rawKlass;
    private static final Unsafe unsafe;
    private static final Constructor<ByteBuffer> directByteBufferConstructor;
    public static final int SIZEOF_BYTE = 1;
    public static final int SIZEOF_SHORT = 2;
    public static final int SIZEOF_CHAR = 2;
    public static final int SIZEOF_INT = 4;
    public static final int SIZEOF_FLOAT = 4;
    public static final int SIZEOF_DOUBLE = 8;
    public static final int SIZEOF_LONG = 8;
    public static final int SIZEOF_ADDRESS;
    private static final int ALIGN_MASK;
    private static final int ALIGN64_MASK = -8;
    private static final long globalVmId;
    private static AddressSizeSpecific addressSpecific;
    private static final int BITS_VM_UID = 26;
    private static final int MAX_VM_UID = 0x3FFFFFF;
    private static final int BITS_VM_ID = 12;
    private static final int MAX_VM_ID = 4095;
    private static final int BITS_THREAD_ID = 26;
    private static final long MAX_THREAD_ID = 0x3FFFFFFL;
    private static final boolean recordAllocations;

    @CallerSensitive
    public static Raw klass() throws SecurityException {
        Class<?> cc = Reflection.getCallerClass();
        if (cc.getClassLoader() != null && cc.getClassLoader() != platformClassLoader) {
            throw new SecurityException("illegal call to raw class");
        }
        return rawKlass;
    }

    private Raw() {
    }

    public Unsafe getUnsafe() {
        return unsafe;
    }

    public long getSharedPoolRoot() {
        return Raw.getSharedPoolRoot0();
    }

    public long getSharedPoolSize() {
        return Raw.getSharedPoolSize0();
    }

    public long allocateSharedMemory(long size) throws OutOfSharedMemoryException {
        long addr = Raw.allocateSharedMemory0(size);
        if (addr == 0L) {
            throw new OutOfSharedMemoryException("failed to allocate " + size + " bytes of shared memory");
        }
        if (recordAllocations) {
            AllocationRecord.allocate(addr, size);
        }
        return addr;
    }

    public void freeSharedMemory(long addr) {
        if (recordAllocations) {
            AllocationRecord.free(addr);
        }
        Raw.freeSharedMemory0(addr);
    }

    public boolean compareAndSwapAddress(long addr, long expectedValue, long newValue) {
        return addressSpecific.compareAndSwapAddress(addr, expectedValue, newValue);
    }

    public long constructGlobalThreadId(int vmId, int vmUid, long localThreadId) {
        return Raw.constructGlobalThreadId(Raw.constructGlobalVmId(vmId, vmUid), localThreadId);
    }

    public int extractVmId(long gtid) {
        return (int)(gtid >>> 26 & 0xFFFL);
    }

    public int extractVmUid(long gtid) {
        return (int)(gtid >>> 38 & 0x3FFFFFFL);
    }

    public long extractThreadId(long gtid) {
        return gtid & 0x3FFFFFFL;
    }

    public long getGlobalThreadId(long localThreadId) {
        return Raw.constructGlobalThreadId(globalVmId, localThreadId);
    }

    public boolean isValidGlobalThreadId(long gtid) {
        return Raw.isValidVm(this.extractVmId(gtid), this.extractVmUid(gtid));
    }

    public static int align(int size) {
        return size + SIZEOF_ADDRESS - 1 & ALIGN_MASK;
    }

    public static int align64(int size) {
        return size + 8 - 1 & 0xFFFFFFF8;
    }

    private static Constructor<ByteBuffer> getDirectByteBufferConstructor() {
        return AccessController.doPrivileged(new PrivilegedAction<Constructor<ByteBuffer>>(){

            @Override
            public Constructor<ByteBuffer> run() {
                try {
                    Class<?> clazz = Class.forName("java.nio.DirectByteBuffer", true, null);
                    Constructor<ByteBuffer> ctor = clazz.getDeclaredConstructor(Long.TYPE, Integer.TYPE);
                    ctor.setAccessible(true);
                    return ctor;
                }
                catch (Exception e) {
                    throw new InternalError("cannot get constructor for direct byte buffer: " + e);
                }
            }
        });
    }

    private static int getVmUid() {
        return Raw.getVmUid0();
    }

    private static int getVmId() {
        return Raw.getVmId0();
    }

    private static boolean isValidVm(int vmId, int vmUid) {
        return Raw.isValidVm0(vmId, vmUid);
    }

    private static long getGlobalVmId() {
        return Raw.constructGlobalVmId(Raw.getVmId(), Raw.getVmUid());
    }

    private static long constructGlobalThreadId(long gvid, long localThreadId) {
        if (localThreadId > 0x3FFFFFFL) {
            throw new InternalError("Thread ID too large: " + localThreadId + " > " + 0x3FFFFFFL);
        }
        return gvid | localThreadId;
    }

    private static long constructGlobalVmId(int vmId, int vmUid) {
        if (vmId > 4095) {
            throw new InternalError("VM ID too large: " + vmId + " > " + 4095);
        }
        if (vmUid > 0x3FFFFFF) {
            throw new InternalError("VM UID too large: " + vmUid + " > " + 0x3FFFFFF);
        }
        return (long)vmUid << 38 | (long)vmId << 26;
    }

    public ByteBuffer createDirectByteBuffer(long addr, int length) {
        if (addr == 0L || length < 0) {
            throw new IllegalArgumentException("Illegal arguments for DirectByteBuffer: addr=" + addr + ", length=" + length);
        }
        try {
            return directByteBufferConstructor.newInstance(addr, length);
        }
        catch (IllegalAccessException e) {
            throw new InternalError("Cannot create direct byte buffer: " + e);
        }
        catch (InstantiationException e) {
            throw new InternalError("Cannot create direct byte buffer: " + e);
        }
        catch (InvocationTargetException e) {
            throw new InternalError("Cannot create direct byte buffer: " + e);
        }
    }

    private static native long getSharedPoolRoot0();

    private static native long getSharedPoolSize0();

    private static native long allocateSharedMemory0(long var0);

    private static native void freeSharedMemory0(long var0);

    private static native int getVmUid0();

    private static native int getVmId0();

    private static native boolean isValidVm0(int var0, int var1);

    private static boolean readRecordAllocationsProperty() {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return System.getProperty("com.sap.jvm.session.raw.recordAllocations", "false").equals("true");
            }
        });
    }

    static {
        try {
            Method method = ClassLoader.class.getMethod("getPlatformClassLoader", new Class[0]);
            platformClassLoader = (ClassLoader)method.invoke(null, new Object[0]);
        }
        catch (IllegalArgumentException | ReflectiveOperationException exception) {
            // empty catch block
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                System.loadLibrary("sapsession");
                return null;
            }
        });
        rawKlass = new Raw();
        unsafe = Unsafe.getUnsafe();
        directByteBufferConstructor = Raw.getDirectByteBufferConstructor();
        SIZEOF_ADDRESS = unsafe.addressSize();
        ALIGN_MASK = ~(SIZEOF_ADDRESS - 1);
        globalVmId = Raw.getGlobalVmId();
        addressSpecific = SIZEOF_ADDRESS == 8 ? new AddressSize64Bit() : new AddressSize32Bit();
        recordAllocations = Raw.readRecordAllocationsProperty();
    }

    private static class AllocationRecord
    extends Throwable {
        private static final long serialVersionUID = 8833943409441088450L;
        private long addr;
        private long size;
        private static HashMap<Long, AllocationRecord> map = new HashMap();
        private static final byte zapAllocated = -95;
        private static final byte zapFreed = -9;

        private AllocationRecord(long addr, long size) {
            this.addr = addr;
            this.size = size;
        }

        static synchronized void allocate(long addr, long size) {
            AllocationRecord record = map.put(addr, new AllocationRecord(addr, size));
            if (record != null) {
                AllocationRecord.reportError("duplicate allocation (addr=" + AllocationRecord.asAddr(addr) + ", size=" + size + "), already have: ", record);
                return;
            }
            unsafe.setMemory(addr, size, (byte)-95);
        }

        static synchronized void free(long addr) {
            if (addr == 0L) {
                return;
            }
            AllocationRecord record = map.remove(addr);
            if (record == null) {
                AllocationRecord.reportError("free without allocation (addr=" + AllocationRecord.asAddr(addr) + ")", null);
                return;
            }
            unsafe.setMemory(record.addr, record.size, (byte)-9);
        }

        static void reportError(String error, AllocationRecord record) {
            new Throwable("ERROR: " + error).printStackTrace(System.err);
            if (record != null) {
                record.printStackTrace(System.err);
            }
        }

        static String asAddr(long addr) {
            return "0x" + Long.toHexString(addr);
        }

        static void dump() {
            if (map.size() == 0) {
                System.err.println("no recorded allocations");
                return;
            }
            int numLines = 0;
            for (AllocationRecord record : map.values()) {
                System.err.println("Allocated " + record.size + " bytes at " + AllocationRecord.asAddr(record.addr));
                record.printStackTrace(System.err);
                if (++numLines <= 100) continue;
                System.err.println("more than 100 recorded allocations, skipping the rest...");
                return;
            }
        }

        static {
            if (recordAllocations) {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        RawSharedPool rawSharedPoolKlass = RawSharedPool.klass();
                        try {
                            Field rawSharedPoolField = SharedPoolImpl.class.getDeclaredField("rawSharedPool");
                            rawSharedPoolField.setAccessible(true);
                            long rawSharedPool = rawSharedPoolField.getLong(null);
                            rawSharedPoolKlass.destroy(rawSharedPool);
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        catch (NoSuchFieldException e) {
                            e.printStackTrace();
                        }
                        AllocationRecord.dump();
                    }
                });
            }
        }
    }

    private static class AddressSize32Bit
    implements AddressSizeSpecific {
        private AddressSize32Bit() {
        }

        @Override
        public boolean compareAndSwapAddress(long addr, long expectedValue, long newValue) {
            return unsafe.compareAndSetInt(null, addr, (int)(expectedValue & 0xFFFFFFFFL), (int)(newValue & 0xFFFFFFFFL));
        }
    }

    private static class AddressSize64Bit
    implements AddressSizeSpecific {
        private AddressSize64Bit() {
        }

        @Override
        public boolean compareAndSwapAddress(long addr, long expectedValue, long newValue) {
            return unsafe.compareAndSetLong(null, addr, expectedValue, newValue);
        }
    }

    private static interface AddressSizeSpecific {
        public boolean compareAndSwapAddress(long var1, long var3, long var5);
    }
}

