/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.session.raw;

import com.sap.jvm.impl.session.raw.Raw;
import com.sap.jvm.session.OutOfSharedMemoryException;
import jdk.internal.misc.Unsafe;
import jdk.internal.reflect.CallerSensitive;
import jdk.internal.reflect.Reflection;

public class RawAddressArray {
    private static final Raw rawKlass = Raw.klass();
    private static final Unsafe unsafe = rawKlass.getUnsafe();
    private static final int Length_OFFSET = 0;
    private static final int Elems_OFFSET;
    private static final int LAST_OFFSET;
    private static final RawAddressArray rawAddressArrayKlass;

    @CallerSensitive
    public static RawAddressArray klass() throws SecurityException {
        Class<?> cc = Reflection.getCallerClass();
        if (cc.getClassLoader() != null && cc.getClassLoader() != Raw.platformClassLoader) {
            throw new SecurityException("illegal call to raw class");
        }
        return rawAddressArrayKlass;
    }

    private RawAddressArray() {
    }

    public long create(int numElems) throws OutOfSharedMemoryException {
        long addr = rawKlass.allocateSharedMemory(this.memSize(numElems));
        this.init(addr, numElems);
        return addr;
    }

    void init(long addr, int numElems) {
        unsafe.setMemory(addr, this.memSize(numElems), (byte)0);
        this.setLength(addr, numElems);
    }

    public void destroy(long addr) {
        if (addr == 0L) {
            return;
        }
        rawKlass.freeSharedMemory(addr);
    }

    int memSize(int numElems) {
        return Raw.align(LAST_OFFSET + numElems * Raw.SIZEOF_ADDRESS);
    }

    public int length(long addr) {
        return unsafe.getInt(addr + 0L);
    }

    private void setLength(long addr, int length) {
        unsafe.putInt(addr + 0L, length);
    }

    public long getAddr(long addr, int offset) {
        if (offset < 0 || offset >= this.length(addr)) {
            throw new ArrayIndexOutOfBoundsException("Array index out of range: " + offset + " < 0 || " + offset + " >= " + this.length(addr));
        }
        return addr + (long)Elems_OFFSET + (long)(offset * Raw.SIZEOF_ADDRESS);
    }

    public long get(long addr, int offset) {
        return unsafe.getAddress(this.getAddr(addr, offset));
    }

    public void set(long addr, int offset, long value) {
        unsafe.putAddress(this.getAddr(addr, offset), value);
    }

    public boolean atomicSwap(long addr, int offset, long expected, long value) {
        return rawKlass.compareAndSwapAddress(this.getAddr(addr, offset), expected, value);
    }

    public long resize(long oldAddr, int newLength) throws OutOfSharedMemoryException {
        int oldLength = this.length(oldAddr);
        if (newLength == oldLength) {
            return oldAddr;
        }
        long newAddr = this.create(newLength);
        int elementsToCopy = Math.min(oldLength, newLength);
        for (int i = 0; i < elementsToCopy; ++i) {
            this.set(newAddr, i, this.get(oldAddr, i));
        }
        this.destroy(oldAddr);
        return newAddr;
    }

    static {
        LAST_OFFSET = Elems_OFFSET = Raw.align(4);
        rawAddressArrayKlass = new RawAddressArray();
    }
}

