/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.session.raw;

import com.sap.jvm.impl.session.raw.Raw;
import com.sap.jvm.session.OutOfSharedMemoryException;
import jdk.internal.misc.Unsafe;
import jdk.internal.reflect.CallerSensitive;
import jdk.internal.reflect.Reflection;

public class RawByteArray {
    private static final Raw rawKlass = Raw.klass();
    private static final Unsafe unsafe = rawKlass.getUnsafe();
    private static final int Length_OFFSET = 0;
    private static final int Elems_OFFSET = 4;
    private static final int LAST_OFFSET = 4;
    private static final RawByteArray rawByteArrayKlass = new RawByteArray();

    @CallerSensitive
    public static RawByteArray klass() throws SecurityException {
        Class<?> cc = Reflection.getCallerClass();
        if (cc.getClassLoader() != null && cc.getClassLoader() != Raw.platformClassLoader) {
            throw new SecurityException("illegal call to raw class");
        }
        return rawByteArrayKlass;
    }

    private RawByteArray() {
    }

    public long create(int numElems) throws OutOfSharedMemoryException {
        long addr = rawKlass.allocateSharedMemory(this.memSize(numElems));
        this.init(addr, numElems);
        return addr;
    }

    void init(long addr, int numElems) {
        this.setLength(addr, numElems);
    }

    public void destroy(long addr) {
        if (addr == 0L) {
            return;
        }
        rawKlass.freeSharedMemory(addr);
    }

    int memSize(int numElems) {
        return Raw.align(4 + numElems * 1);
    }

    public int length(long addr) {
        return unsafe.getInt(addr + 0L);
    }

    private void setLength(long addr, int length) {
        unsafe.putInt(addr + 0L, length);
    }

    public long getAddr(long addr, int offset) {
        if (offset < 0 || offset >= this.length(addr)) {
            throw new ArrayIndexOutOfBoundsException("Array index out of range: " + offset + " < 0 || " + offset + " >= " + this.length(addr));
        }
        return addr + 4L + (long)(offset * 1);
    }

    public byte get(long addr, int offset) {
        return unsafe.getByte(this.getAddr(addr, offset));
    }

    public void set(long addr, int offset, byte value) {
        unsafe.putByte(this.getAddr(addr, offset), value);
    }

    public long resize(long oldAddr, int newLength) throws OutOfSharedMemoryException {
        int oldLength = this.length(oldAddr);
        if (newLength == oldLength) {
            return oldAddr;
        }
        long newAddr = this.create(newLength);
        int elementsToCopy = Math.min(oldLength, newLength);
        for (int i = 0; i < elementsToCopy; ++i) {
            this.set(newAddr, i, this.get(oldAddr, i));
        }
        this.destroy(oldAddr);
        return newAddr;
    }
}

