/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.session.raw;

import com.sap.jvm.impl.session.Configuration;
import com.sap.jvm.impl.session.raw.Raw;
import com.sap.jvm.impl.session.raw.RawAddressArray;
import com.sap.jvm.impl.session.raw.RawByteArray;
import com.sap.jvm.session.OutOfSharedMemoryException;
import jdk.internal.misc.Unsafe;
import jdk.internal.reflect.CallerSensitive;
import jdk.internal.reflect.Reflection;

public class RawChunk {
    private static final RawByteArray rawByteArrayKlass = RawByteArray.klass();
    private static final RawAddressArray rawAddressArrayKlass = RawAddressArray.klass();
    private static final Raw rawKlass = Raw.klass();
    private static final Unsafe unsafe = rawKlass.getUnsafe();
    private static final int Size_OFFSET = 0;
    private static final int Accessor_OFFSET = Raw.align64(8);
    private static final int NumBuffers_OFFSET = Accessor_OFFSET + 8;
    private static final int Buffers_OFFSET = Raw.align(NumBuffers_OFFSET + 4);
    private static final int LAST_OFFSET = Buffers_OFFSET + Raw.SIZEOF_ADDRESS;
    private static final int DEFAULT_INITIAL_BUFFER_ARRAY_SIZE = 32;
    private static final int INITIAL_BUFFER_ARRAY_SIZE = Configuration.getInitialBuffersPerChunk(32);
    private static final RawChunk rawChunkKlass = new RawChunk();

    @CallerSensitive
    public static RawChunk klass() throws SecurityException {
        Class<?> cc = Reflection.getCallerClass();
        if (cc.getClassLoader() != null && cc.getClassLoader() != Raw.platformClassLoader) {
            throw new SecurityException("illegal call to raw class");
        }
        return rawChunkKlass;
    }

    private RawChunk() {
    }

    public long create() throws OutOfSharedMemoryException {
        long addr = rawKlass.allocateSharedMemory(this.memSize());
        unsafe.setMemory(addr, this.memSize(), (byte)0);
        try {
            this.init(addr);
        }
        catch (OutOfSharedMemoryException e) {
            this.destroy(addr);
            throw e;
        }
        return addr;
    }

    void init(long addr) throws OutOfSharedMemoryException {
        this.setBuffers(addr, rawAddressArrayKlass.create(INITIAL_BUFFER_ARRAY_SIZE));
    }

    void destroyContent(long addr) {
        if (addr == 0L) {
            return;
        }
        long buffers = this.getBuffers(addr);
        if (buffers != 0L) {
            for (int i = 0; i < rawAddressArrayKlass.length(buffers); ++i) {
                rawByteArrayKlass.destroy(rawAddressArrayKlass.get(buffers, i));
            }
            rawAddressArrayKlass.destroy(buffers);
        }
    }

    public void destroy(long addr) {
        if (addr == 0L) {
            return;
        }
        this.destroyContent(addr);
        rawKlass.freeSharedMemory(addr);
    }

    int memSize() {
        return Raw.align(LAST_OFFSET);
    }

    public long getSize(long addr) {
        return unsafe.getLong(addr + 0L);
    }

    public void setSize(long addr, long value) {
        unsafe.putLong(addr + 0L, value);
    }

    public long getAccessor(long addr) {
        return unsafe.getLong(addr + (long)Accessor_OFFSET);
    }

    public void setAccessor(long addr, long value) {
        unsafe.putLong(addr + (long)Accessor_OFFSET, value);
    }

    public int getNumBuffers(long addr) {
        return unsafe.getInt(addr + (long)NumBuffers_OFFSET);
    }

    public void setNumBuffers(long addr, int value) {
        unsafe.putInt(addr + (long)NumBuffers_OFFSET, value);
    }

    public long getBuffers(long addr) {
        return unsafe.getAddress(addr + (long)Buffers_OFFSET);
    }

    public void setBuffers(long addr, long value) {
        unsafe.putAddress(addr + (long)Buffers_OFFSET, value);
    }
}

