/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.session.raw;

import com.sap.jvm.impl.session.Configuration;
import com.sap.jvm.impl.session.raw.Raw;
import com.sap.jvm.impl.session.raw.RawHashEntry;
import com.sap.jvm.impl.session.raw.RawHashMap;
import com.sap.jvm.session.OutOfSharedMemoryException;
import jdk.internal.misc.Unsafe;
import jdk.internal.reflect.CallerSensitive;
import jdk.internal.reflect.Reflection;

public class RawDomain {
    private static final RawHashMap rawHashMapKlass = RawHashMap.klass();
    private static final RawHashEntry rawHashEntryKlass = RawHashEntry.klass();
    private static final Raw rawKlass = Raw.klass();
    private static final Unsafe unsafe = rawKlass.getUnsafe();
    private static final int SessionMap_OFFSET = Raw.align(rawHashEntryKlass.memSize());
    private static final int LAST_OFFSET = SessionMap_OFFSET + rawHashMapKlass.memSize();
    public static final int TYPE = 2;
    private static final int DEFAULT_INITIAL_SESSION_MAP_SIZE = 1024;
    private static final int INITIAL_SESSION_MAP_SIZE = Configuration.getInitialSessionsPerDomain(1024);
    private static final RawDomain rawDomainKlass = new RawDomain();

    @CallerSensitive
    public static RawDomain klass() throws SecurityException {
        Class<?> cc = Reflection.getCallerClass();
        if (cc.getClassLoader() != null && cc.getClassLoader() != Raw.platformClassLoader) {
            throw new SecurityException("illegal call to raw class");
        }
        return rawDomainKlass;
    }

    private RawDomain() {
    }

    public long create(String name) throws OutOfSharedMemoryException {
        long addr = rawKlass.allocateSharedMemory(this.memSize());
        unsafe.setMemory(addr, this.memSize(), (byte)0);
        try {
            this.init(addr, name);
        }
        catch (OutOfSharedMemoryException e) {
            this.destroy(addr);
            throw e;
        }
        return addr;
    }

    void init(long addr, String name) throws OutOfSharedMemoryException {
        rawHashEntryKlass.init(addr, 2, name);
        rawHashMapKlass.init(this.getSessionMap(addr), INITIAL_SESSION_MAP_SIZE);
    }

    void destroyContent(long addr) {
        if (addr == 0L) {
            return;
        }
        rawHashEntryKlass.destroyContent(addr);
        rawHashMapKlass.destroyContent(this.getSessionMap(addr));
    }

    public void destroy(long addr) {
        if (addr == 0L) {
            return;
        }
        this.destroyContent(addr);
        rawKlass.freeSharedMemory(addr);
    }

    int memSize() {
        return Raw.align(LAST_OFFSET);
    }

    public long getSessionMap(long addr) {
        return addr + (long)SessionMap_OFFSET;
    }

    public long getName(long addr) {
        return rawHashEntryKlass.getName(addr);
    }

    public long getNext(long addr) {
        return rawHashEntryKlass.getNext(addr);
    }

    public void setNext(long addr, long value) {
        rawHashEntryKlass.setNext(addr, value);
    }

    public int getHandle(long addr) {
        return rawHashEntryKlass.getHandle(addr);
    }

    public void setHandle(long addr, int value) {
        rawHashEntryKlass.setHandle(addr, value);
    }

    public int getType(long addr) {
        return rawHashEntryKlass.getType(addr);
    }
}

