/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.session.raw;

import com.sap.jvm.impl.session.raw.Raw;
import com.sap.jvm.impl.session.raw.RawItem;
import com.sap.jvm.impl.session.raw.RawString;
import com.sap.jvm.session.OutOfSharedMemoryException;
import jdk.internal.misc.Unsafe;
import jdk.internal.reflect.CallerSensitive;
import jdk.internal.reflect.Reflection;

public class RawHashEntry {
    private static final RawString rawStringKlass = RawString.klass();
    private static final RawItem rawItemKlass = RawItem.klass();
    private static final Raw rawKlass = Raw.klass();
    private static final Unsafe unsafe = rawKlass.getUnsafe();
    private static final int Name_OFFSET = Raw.align(rawItemKlass.memSize());
    private static final int Next_OFFSET = Raw.align(Name_OFFSET + Raw.SIZEOF_ADDRESS);
    private static final int LAST_OFFSET = Next_OFFSET + Raw.SIZEOF_ADDRESS;
    private static final RawHashEntry rawHashEntryKlass = new RawHashEntry();

    @CallerSensitive
    public static RawHashEntry klass() throws SecurityException {
        Class<?> cc = Reflection.getCallerClass();
        if (cc.getClassLoader() != null && cc.getClassLoader() != Raw.platformClassLoader) {
            throw new SecurityException("illegal call to raw class");
        }
        return rawHashEntryKlass;
    }

    private RawHashEntry() {
    }

    public long create(int type, String name) throws OutOfSharedMemoryException {
        long addr = rawKlass.allocateSharedMemory(this.memSize());
        unsafe.setMemory(addr, this.memSize(), (byte)0);
        try {
            this.init(addr, type, name);
        }
        catch (OutOfSharedMemoryException e) {
            this.destroy(addr);
            throw e;
        }
        return addr;
    }

    void init(long addr, int type, String name) throws OutOfSharedMemoryException {
        rawItemKlass.init(addr, type);
        this.setName(addr, rawStringKlass.create(name));
    }

    void destroyContent(long addr) {
        if (addr == 0L) {
            return;
        }
        rawItemKlass.destroyContent(addr);
        rawStringKlass.destroy(this.getName(addr));
    }

    public void destroy(long addr) {
        if (addr == 0L) {
            return;
        }
        this.destroyContent(addr);
        rawKlass.freeSharedMemory(addr);
    }

    int memSize() {
        return Raw.align(LAST_OFFSET);
    }

    public long getName(long addr) {
        return unsafe.getAddress(addr + (long)Name_OFFSET);
    }

    private void setName(long addr, long value) {
        unsafe.putAddress(addr + (long)Name_OFFSET, value);
    }

    public long getNext(long addr) {
        return unsafe.getAddress(addr + (long)Next_OFFSET);
    }

    public long getNextAddr(long addr) {
        return addr + (long)Next_OFFSET;
    }

    public void setNext(long addr, long value) {
        unsafe.putAddress(addr + (long)Next_OFFSET, value);
    }

    public int hashCode(long addr) {
        return rawStringKlass.hashCode(this.getName(addr));
    }

    public boolean equals(long addr, String name) {
        return rawStringKlass.equals(this.getName(addr), name);
    }

    public int getHandle(long addr) {
        return rawItemKlass.getHandle(addr);
    }

    public void setHandle(long addr, int value) {
        rawItemKlass.setHandle(addr, value);
    }

    public int getType(long addr) {
        return rawItemKlass.getType(addr);
    }
}

