/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.session.raw;

import com.sap.jvm.impl.session.Configuration;
import com.sap.jvm.impl.session.raw.Raw;
import com.sap.jvm.impl.session.raw.RawAddressArray;
import com.sap.jvm.impl.session.raw.RawHashEntry;
import com.sap.jvm.session.OutOfSharedMemoryException;
import jdk.internal.misc.Unsafe;
import jdk.internal.reflect.CallerSensitive;
import jdk.internal.reflect.Reflection;

public class RawHashMap {
    private static final RawHashEntry rawHashEntryKlass = RawHashEntry.klass();
    private static final RawAddressArray rawAddressArrayKlass = RawAddressArray.klass();
    private static final Raw rawKlass = Raw.klass();
    private static final Unsafe unsafe = rawKlass.getUnsafe();
    private static final int Size_OFFSET = 0;
    private static final int MaxSize_OFFSET = 4;
    private static final int Values_OFFSET = Raw.align(8);
    private static final int LAST_OFFSET = Raw.align(Values_OFFSET + Raw.SIZEOF_ADDRESS);
    private static final int DEFAULT_LOAD_FACTOR = 4;
    private static final int LOAD_FACTOR = Configuration.getHashLoadFactor(4);
    private static final RawHashMap rawHashMapKlass = new RawHashMap();

    @CallerSensitive
    public static RawHashMap klass() throws SecurityException {
        Class<?> cc = Reflection.getCallerClass();
        if (cc.getClassLoader() != null && cc.getClassLoader() != Raw.platformClassLoader) {
            throw new SecurityException("illegal call to raw class");
        }
        return rawHashMapKlass;
    }

    private RawHashMap() {
    }

    public long create(int initialCapacity) throws OutOfSharedMemoryException {
        long addr = rawKlass.allocateSharedMemory(this.memSize());
        unsafe.setMemory(addr, this.memSize(), (byte)0);
        try {
            this.init(addr, initialCapacity);
        }
        catch (OutOfSharedMemoryException e) {
            this.destroy(addr);
            throw e;
        }
        return addr;
    }

    void init(long addr, int initialCapacity) throws OutOfSharedMemoryException {
        this.setSize(addr, 0);
        this.setMaxSize(addr, initialCapacity);
        int numBuckets = initialCapacity / LOAD_FACTOR;
        if (numBuckets <= 0) {
            numBuckets = 1;
        }
        this.setValues(addr, rawAddressArrayKlass.create(numBuckets));
    }

    void destroyContent(long addr) {
        if (addr == 0L) {
            return;
        }
        rawAddressArrayKlass.destroy(this.getValues(addr));
    }

    public void destroy(long addr) {
        if (addr == 0L) {
            return;
        }
        this.destroyContent(addr);
        rawKlass.freeSharedMemory(addr);
    }

    int memSize() {
        return Raw.align(LAST_OFFSET);
    }

    public int getSize(long addr) {
        return unsafe.getInt(addr + 0L);
    }

    private void setSize(long addr, int value) {
        unsafe.putInt(addr + 0L, value);
    }

    private int getMaxSize(long addr) {
        return unsafe.getInt(addr + 4L);
    }

    private void setMaxSize(long addr, int value) {
        unsafe.putInt(addr + 4L, value);
    }

    private long getValues(long addr) {
        return unsafe.getAddress(addr + (long)Values_OFFSET);
    }

    private void setValues(long addr, long value) {
        unsafe.putAddress(addr + (long)Values_OFFSET, value);
    }

    public void put(long addr, long rawHashEntry) throws OutOfSharedMemoryException {
        this.checkResize(addr);
        long rawValues = this.getValues(addr);
        int numBuckets = rawAddressArrayKlass.length(rawValues);
        int bucket = RawHashMap.bucket(rawHashEntryKlass.hashCode(rawHashEntry), numBuckets);
        rawHashEntryKlass.setNext(rawHashEntry, rawAddressArrayKlass.get(rawValues, bucket));
        rawAddressArrayKlass.set(rawValues, bucket, rawHashEntry);
        this.setSize(addr, this.getSize(addr) + 1);
    }

    public long get(long addr, String name) {
        long rawValues = this.getValues(addr);
        int numBuckets = rawAddressArrayKlass.length(rawValues);
        int bucket = RawHashMap.bucket(name.hashCode(), numBuckets);
        long candidate = rawAddressArrayKlass.get(rawValues, bucket);
        while (candidate != 0L && !rawHashEntryKlass.equals(candidate, name)) {
            candidate = rawHashEntryKlass.getNext(candidate);
        }
        return candidate;
    }

    public boolean remove(long addr, long rawHashEntry) {
        long candidate;
        long rawValues = this.getValues(addr);
        int numBuckets = rawAddressArrayKlass.length(rawValues);
        int bucket = RawHashMap.bucket(rawHashEntryKlass.hashCode(rawHashEntry), numBuckets);
        long candidateAddr = rawAddressArrayKlass.getAddr(rawValues, bucket);
        while ((candidate = unsafe.getAddress(candidateAddr)) != 0L && candidate != rawHashEntry) {
            candidateAddr = rawHashEntryKlass.getNextAddr(candidate);
        }
        if (candidate != 0L) {
            unsafe.putAddress(candidateAddr, rawHashEntryKlass.getNext(candidate));
            this.setSize(addr, this.getSize(addr) - 1);
            return true;
        }
        return false;
    }

    public int[] getAllHandles(long addr) {
        long rawValues = this.getValues(addr);
        int numBuckets = rawAddressArrayKlass.length(rawValues);
        int[] handles = new int[this.getSize(addr)];
        int i = 0;
        for (int bucket = 0; bucket < numBuckets; ++bucket) {
            long hashEntry = rawAddressArrayKlass.get(rawValues, bucket);
            while (hashEntry != 0L) {
                handles[i++] = rawHashEntryKlass.getHandle(hashEntry);
                hashEntry = rawHashEntryKlass.getNext(hashEntry);
            }
        }
        return handles;
    }

    private void checkResize(long addr) throws OutOfSharedMemoryException {
        if (this.getSize(addr) + 1 <= this.getMaxSize(addr)) {
            return;
        }
        long rawValues = this.getValues(addr);
        int numBuckets = rawAddressArrayKlass.length(rawValues);
        int newNumBuckets = numBuckets * 2;
        long newValues = rawAddressArrayKlass.create(newNumBuckets);
        for (int bucket = 0; bucket < numBuckets; ++bucket) {
            long hashEntry = rawAddressArrayKlass.get(rawValues, bucket);
            while (hashEntry != 0L) {
                long nextHashEntry = rawHashEntryKlass.getNext(hashEntry);
                int newBucket = RawHashMap.bucket(rawHashEntryKlass.hashCode(hashEntry), newNumBuckets);
                rawHashEntryKlass.setNext(hashEntry, rawAddressArrayKlass.get(newValues, newBucket));
                rawAddressArrayKlass.set(newValues, newBucket, hashEntry);
                hashEntry = nextHashEntry;
            }
        }
        this.setValues(addr, newValues);
        this.setMaxSize(addr, this.getMaxSize(addr) * 2);
        rawAddressArrayKlass.destroy(rawValues);
    }

    private static int bucket(int hashCode, int numBuckets) {
        int h = hashCode % numBuckets;
        return h < 0 ? h + numBuckets : h;
    }
}

