/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.session.raw;

import com.sap.jvm.impl.session.raw.Raw;
import com.sap.jvm.session.OutOfSharedMemoryException;
import jdk.internal.misc.Unsafe;
import jdk.internal.reflect.CallerSensitive;
import jdk.internal.reflect.Reflection;

public class RawItem {
    private static final Raw rawKlass = Raw.klass();
    private static final Unsafe unsafe = rawKlass.getUnsafe();
    private static final int Handle_OFFSET = 0;
    private static final int Type_OFFSET = 4;
    private static final int LAST_OFFSET = 8;
    private static final RawItem rawItemKlass = new RawItem();

    @CallerSensitive
    public static RawItem klass() throws SecurityException {
        Class<?> cc = Reflection.getCallerClass();
        if (cc.getClassLoader() != null && cc.getClassLoader() != Raw.platformClassLoader) {
            throw new SecurityException("illegal call to raw class");
        }
        return rawItemKlass;
    }

    private RawItem() {
    }

    public long create(int type) throws OutOfSharedMemoryException {
        long addr = rawKlass.allocateSharedMemory(this.memSize());
        this.init(addr, type);
        return addr;
    }

    void init(long addr, int type) {
        this.setType(addr, type);
        this.setHandle(addr, -1);
    }

    void destroyContent(long addr) {
    }

    public void destroy(long addr) {
        if (addr == 0L) {
            return;
        }
        this.destroyContent(addr);
        rawKlass.freeSharedMemory(addr);
    }

    int memSize() {
        return Raw.align(8);
    }

    public int getHandle(long addr) {
        return unsafe.getInt(addr + 0L);
    }

    public void setHandle(long addr, int value) {
        unsafe.putInt(addr + 0L, value);
    }

    public int getType(long addr) {
        return unsafe.getInt(addr + 4L);
    }

    private void setType(long addr, int value) {
        unsafe.putInt(addr + 4L, value);
    }
}

